/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzSheduler
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.QuartzSheduler");
    private static final String defaultDriverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
    private static final String PGSQLDriverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
    private static final String MSSQLlDriverDelegateClass = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
    private static final String datasourceProperty = "org.quartz.dataSource.quartzDS.jndiURL";
    private static final String delegateClassProperty = "org.quartz.jobStore.driverDelegateClass";
    private final Scheduler scheduler_;

    public QuartzSheduler(ExoContainerContext ctx, InitParams params) throws Exception {
        StdSchedulerFactory sf;
        if (params != null && !params.isEmpty()) {
            String datasourceName;
            Properties props = new Properties();
            for (String key : params.keySet()) {
                props.setProperty(key, params.getValueParam(key).getValue());
            }
            String oldValue = props.getProperty(delegateClassProperty);
            if ((oldValue == null || oldValue.isEmpty() || oldValue.equals(defaultDriverDelegateClass)) && (datasourceName = props.getProperty(datasourceProperty)) != null && !datasourceName.isEmpty()) {
                try (Connection conn = this.getConnection(datasourceName);){
                    DatabaseMetaData meta = conn.getMetaData();
                    String newValue = this.getDriverDelegateClass(meta);
                    props.setProperty(delegateClassProperty, newValue);
                }
            }
            sf = new StdSchedulerFactory(props);
        } else {
            sf = new StdSchedulerFactory();
        }
        try {
            this.scheduler_ = (Scheduler)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Scheduler>((SchedulerFactory)sf){
                final /* synthetic */ SchedulerFactory val$sf;
                {
                    this.val$sf = schedulerFactory;
                }

                @Override
                public Scheduler run() throws Exception {
                    return this.val$sf.getScheduler();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof SchedulerException) {
                throw (SchedulerException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        this.scheduler_.standby();
        ctx.getContainer().addContainerLifecylePlugin((ContainerLifecyclePlugin)new BaseContainerLifecyclePlugin(){

            public void startContainer(ExoContainer container) throws Exception {
                QuartzSheduler.this.scheduler_.start();
            }
        });
    }

    public Scheduler getQuartzSheduler() {
        return this.scheduler_;
    }

    public void start() {
    }

    public void stop() {
        try {
            this.scheduler_.shutdown();
        }
        catch (SchedulerException ex) {
            LOG.warn((Object)"Could not shutdown the scheduler", (Throwable)ex);
        }
    }

    private Connection getConnection(String dsName) throws Exception {
        final DataSource dsF = (DataSource)new InitialContext().lookup(dsName);
        Connection jdbcConn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return dsF.getConnection();
            }
        });
        return jdbcConn;
    }

    private String getDriverDelegateClass(final DatabaseMetaData metaData) throws Exception {
        String databaseName = (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public String run() throws Exception {
                return metaData.getDatabaseProductName();
            }
        });
        if (databaseName == null || databaseName.isEmpty()) {
            LOG.warn((Object)"The database name cannot be retrieve, the default DriverDelegateClass will be used for Quartz.");
            return defaultDriverDelegateClass;
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return MSSQLlDriverDelegateClass;
        }
        if (databaseName.startsWith("PostgreSQL")) {
            return PGSQLDriverDelegateClass;
        }
        return defaultDriverDelegateClass;
    }
}

