/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.upgrade;

import java.util.List;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PushNotificationSettingsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(PushNotificationSettingsUpgradePlugin.class);
    private SettingService settingService;
    private UserSettingService userSettingService;
    private PluginSettingService pluginSettingService;
    private EntityManagerService entityManagerService;

    public PushNotificationSettingsUpgradePlugin(SettingService settingService, UserSettingService userSettingService, PluginSettingService pluginSettingService, EntityManagerService entityManagerService, InitParams initParams) {
        super(settingService, initParams);
        this.settingService = settingService;
        this.userSettingService = userSettingService;
        this.pluginSettingService = pluginSettingService;
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        int pageSize = 20;
        int current = 0;
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        try {
            List usersContexts;
            LOG.info((Object)"=== Start initialisation of Push Notifications settings");
            LOG.info((Object)"  Activate Push Notifications channel for all notification plugins");
            this.pluginSettingService.getAllPlugins().forEach(pluginInfo -> {
                this.pluginSettingService.saveActivePlugin("PUSH_CHANNEL", pluginInfo.getType(), true);
                this.pluginSettingService.getGroupPlugins().forEach(groupProvider -> groupProvider.getPluginInfos().stream().filter(groupPluginInfo -> groupPluginInfo.getType().equals(pluginInfo.getType())).findFirst().ifPresent(matchedPluginInfo -> matchedPluginInfo.setChannelActive("PUSH_CHANNEL")));
            });
            LOG.info((Object)"  Starting activating Push Notifications for users");
            this.entityManagerService.startRequest(currentContainer);
            long startTime = System.currentTimeMillis();
            do {
                LOG.info("  Progression of users Push Notifications settings initialisation : {} users", new Object[]{current});
                usersContexts = this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Scope.APPLICATION.getName(), "NOTIFICATION", "exo:isActive", current, pageSize);
                if (usersContexts == null) continue;
                for (Context userContext : usersContexts) {
                    try {
                        this.entityManagerService.endRequest(currentContainer);
                        this.entityManagerService.startRequest(currentContainer);
                        String userName = userContext.getId();
                        SettingValue pushNotificationChannelSetting = this.settingService.get(userContext, Scope.APPLICATION.id("NOTIFICATION"), "exo:PUSH_CHANNELChannel");
                        if (pushNotificationChannelSetting != null) continue;
                        UserSetting userSetting = this.userSettingService.get(userName);
                        if (userSetting.isChannelActive("WEB_CHANNEL")) {
                            userSetting.setChannelActive("PUSH_CHANNEL");
                        } else {
                            userSetting.removeChannelActive("PUSH_CHANNEL");
                        }
                        List plugins = userSetting.getPlugins("WEB_CHANNEL");
                        userSetting.setChannelPlugins("PUSH_CHANNEL", plugins);
                        this.userSettingService.save(userSetting);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("  Error while activating Push Notifications for user " + userContext.getId()), (Throwable)e);
                    }
                }
                current += usersContexts.size();
            } while (usersContexts != null && !usersContexts.isEmpty());
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("  Users Push Notifications settings initialised in " + (endTime - startTime) + " ms"));
        }
        catch (Exception e) {
            LOG.error((Object)("Error while initialisation of users Push Notifications settings - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.entityManagerService.endRequest(currentContainer);
        }
        LOG.info("=== {} users with modified notifications settings have been found and processed successfully", new Object[]{current});
        LOG.info((Object)"=== End initialisation of Push Notifications settings");
    }
}

