/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class IdentitySetLoginModule
extends AbstractLoginModule {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.IdentitySetLoginModule");
    protected boolean singleLogin;

    @Override
    public boolean abort() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in abort");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in commit");
        }
        String userId = (String)this.sharedState.get("javax.security.auth.login.name");
        try {
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration.");
            }
            IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
            if (this.singleLogin && identityRegistry.getIdentity(userId) != null) {
                throw new LoginException("User " + userId + " already logined.");
            }
            Identity identity = authenticator.createIdentity(userId);
            identity.setSubject(this.subject);
            identityRegistry.register(identity);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw new LoginException(e.getMessage());
        }
        return true;
    }

    @Override
    public void afterInitialize() {
        String sl;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in initialize");
        }
        this.singleLogin = (sl = (String)this.options.get("singleLogin")) != null && (sl.equalsIgnoreCase("yes") || sl.equalsIgnoreCase("true"));
    }

    @Override
    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in login");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"in logout");
        }
        return true;
    }

    @Override
    protected Log getLogger() {
        return LOG;
    }
}

