/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.NoteService;

public class MetadataItemModified
extends Listener<Long, MetadataItem> {
    private IndexingService indexingService;
    private NoteService noteService;
    private CachedActivityStorage cachedActivityStorage;

    public MetadataItemModified(NoteService noteService, IndexingService indexingService, ActivityStorage activityStorage) {
        this.noteService = noteService;
        this.indexingService = indexingService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = metadataItem.getObjectType();
        String objectId = metadataItem.getObjectId();
        if (this.isNotesEvent(objectType)) {
            Page page = this.noteService.getNoteById(objectId);
            if (page != null && StringUtils.isNotBlank((CharSequence)page.getActivityId())) {
                this.clearCache(page.getActivityId());
            }
            this.reindexNotes(objectId);
        }
    }

    protected boolean isNotesEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"notes");
    }

    private void clearCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }

    private void reindexNotes(String pageId) {
        this.indexingService.reindex("wiki-page", pageId);
    }
}

