/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.create.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class CreateSchema
implements Statement {
    private String authorization;
    private String schemaName;
    private List<String> schemaPath;
    private List<Statement> statements = new ArrayList<Statement>();

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public boolean addStatement(Statement statement) {
        return this.statements.add(statement);
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setAuthorization(String string) {
        this.authorization = string;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public void setSchemaPath(List<String> list) {
        this.schemaPath = list;
    }

    public String toString() {
        String string = "CREATE SCHEMA";
        if (this.schemaName != null) {
            string = string + " " + this.schemaName;
        }
        if (this.authorization != null) {
            string = string + " AUTHORIZATION " + this.authorization;
        }
        return string;
    }

    public CreateSchema withAuthorization(String string) {
        this.setAuthorization(string);
        return this;
    }

    public CreateSchema withSchemaName(String string) {
        this.setSchemaName(string);
        return this;
    }

    public CreateSchema withSchemaPath(List<String> list) {
        this.setSchemaPath(list);
        return this;
    }

    public CreateSchema addSchemaPath(String ... stringArray) {
        List list = Optional.ofNullable(this.getSchemaPath()).orElseGet(ArrayList::new);
        Collections.addAll(list, stringArray);
        return this.withSchemaPath(list);
    }

    public CreateSchema addSchemaPath(Collection<String> collection) {
        List list = Optional.ofNullable(this.getSchemaPath()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSchemaPath(list);
    }
}

