/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/OnlyofficeFileViewer.gtmpl")
public class OnlyofficeFileViewer
extends UIForm {
    private static final Log LOG = ExoLogger.getExoLogger(OnlyofficeFileViewer.class);

    public Config getFileViewerConfig(String fileId, String workspace) {
        OnlyofficeEditorService editorService = (OnlyofficeEditorService)WCMCoreUtils.getService(OnlyofficeEditorService.class);
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        try {
            Config config = editorService.createViewer(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser(), workspace, fileId);
            return config;
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)("Cannot create viewer config for fileId: " + fileId + ", workspace: " + workspace), e);
            return null;
        }
    }
}

