/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.oauth.filter.OAuthAbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PasswordStringLengthValidator;
import org.exoplatform.webui.form.validator.PersonalNameValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.UserConfigurableValidator;
import org.exoplatform.webui.form.validator.Validator;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.utils.OAuthUtils;

public class OAuthLoginServletFilter
extends OAuthAbstractFilter {
    private final Log log = ExoLogger.getLogger(OAuthLoginServletFilter.class);
    public static final String CONTROLLER_PARAM_NAME = "login_controller";
    public static final String CANCEL_OAUTH = "oauth_cancel";
    public static final String CONFIRM_ACCOUNT = "confirm_account";
    public static final String REGISTER_NEW_ACCOUNT = "register";
    public static final String CONFIRM_REGISTER_ACCOUNT = "submit_register";
    public static final String SESSION_ATTR_REGISTER_NEW_ACCOUNT = "__oauth_create_new_account";

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ((HttpServletRequest)request).getSession().removeAttribute("_oauthException");
        super.doFilter(request, response, chain);
    }

    @Override
    protected void executeFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String controller;
        req.setCharacterEncoding("UTF-8");
        AuthenticationRegistry authReg = this.getService(AuthenticationRegistry.class);
        ResourceBundleService service = this.getService(ResourceBundleService.class);
        ResourceBundle bundle = service.getResourceBundle(service.getSharedResourceBundleNames(), req.getLocale());
        MessageResolver messageResolver = new MessageResolver(bundle);
        ServletContext context = this.getContext();
        Boolean isOnFlyError = (Boolean)req.getSession().getAttribute("oauth_onfly_error");
        if (isOnFlyError != null) {
            req.getSession().removeAttribute("oauth_onfly_error");
            req.setAttribute("isOnFlyError", (Object)isOnFlyError);
        }
        User portalUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUser");
        User detectedUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUserDetected");
        req.setAttribute("portalUser", (Object)portalUser);
        if (detectedUser != null) {
            req.setAttribute("detectedUser", (Object)detectedUser);
        }
        if (CANCEL_OAUTH.equalsIgnoreCase(controller = req.getParameter(CONTROLLER_PARAM_NAME))) {
            this.cancelOauth(req, res, authReg);
            return;
        }
        if (CONFIRM_ACCOUNT.equalsIgnoreCase(controller)) {
            this.confirmExistingAccount(req, res, messageResolver, authReg);
            return;
        }
        if (CONFIRM_REGISTER_ACCOUNT.equalsIgnoreCase(controller)) {
            this.processCreateNewAccount(req, res, messageResolver, authReg, portalUser);
            return;
        }
        if (REGISTER_NEW_ACCOUNT.equalsIgnoreCase(controller)) {
            req.getSession(true).setAttribute(SESSION_ATTR_REGISTER_NEW_ACCOUNT, (Object)new Integer(1));
        }
        Integer createNewAccount = (Integer)req.getSession().getAttribute(SESSION_ATTR_REGISTER_NEW_ACCOUNT);
        if (detectedUser != null && createNewAccount == null) {
            RequestDispatcher invitation = context.getRequestDispatcher("/WEB-INF/jsp/login/oauth_invitation.jsp");
            if (invitation != null) {
                invitation.forward((ServletRequest)req, (ServletResponse)res);
                return;
            }
        } else {
            RequestDispatcher register = context.getRequestDispatcher("/login/jsp/oauth_register.jsp");
            if (register != null) {
                register.forward((ServletRequest)req, (ServletResponse)res);
                return;
            }
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void cancelOauth(HttpServletRequest req, HttpServletResponse res, AuthenticationRegistry authReg) throws IOException {
        req.getSession().removeAttribute(SESSION_ATTR_REGISTER_NEW_ACCOUNT);
        authReg.removeAttributeOfClient(req, "_authenticatedOAuthPrincipal");
        authReg.removeAttributeOfClient(req, "_authenticatedPortalUser");
        authReg.removeAttributeOfClient(req, "_authenticatedPortalUserDetected");
        String initialURL = OAuthUtils.getURLToRedirectAfterLinkAccount((HttpServletRequest)req, (HttpSession)req.getSession());
        if (initialURL == null) {
            initialURL = req.getServletPath();
        }
        res.sendRedirect(res.encodeRedirectURL(initialURL));
    }

    private void confirmExistingAccount(HttpServletRequest req, HttpServletResponse res, MessageResolver bundle, AuthenticationRegistry authReg) throws IOException, ServletException {
        User detectedUser = (User)authReg.getAttributeOfClient(req, "_authenticatedPortalUserDetected");
        if (detectedUser == null) {
            req.setAttribute("invitationConfirmError", (Object)bundle.resolve("UIOAuthInvitationForm.message.not-in-oauth-login", new Object[0]));
            this.getContext().getRequestDispatcher("/login/jsp/oauth_invitation.jsp").forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String username = detectedUser.getUserName();
        String password = req.getParameter("password");
        Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
        Authenticator authenticator = this.getService(Authenticator.class);
        try {
            OrganizationService orgService = this.getService(OrganizationService.class);
            String user = authenticator.validateUser(credentials);
            if (user != null && !user.isEmpty()) {
                OAuthPrincipal principal = (OAuthPrincipal)authReg.getAttributeOfClient(req, "_authenticatedOAuthPrincipal");
                OAuthProviderType providerType = principal.getOauthProviderType();
                UserProfileHandler profileHandler = orgService.getUserProfileHandler();
                UserProfile newUserProfile = profileHandler.findUserProfileByName(user);
                if (newUserProfile == null) {
                    newUserProfile = orgService.getUserProfileHandler().createUserProfileInstance(user);
                }
                newUserProfile.setAttribute(providerType.getUserNameAttrName(), principal.getUserName());
                profileHandler.saveUserProfile(newUserProfile, true);
                authReg.removeAttributeOfClient(req, "_authenticatedPortalUser");
                authReg.removeAttributeOfClient(req, "_authenticatedPortalUserDetected");
                String initURL = OAuthUtils.getURLToRedirectAfterLinkAccount((HttpServletRequest)req, (HttpSession)req.getSession());
                if (initURL == null) {
                    initURL = req.getServletPath();
                }
                res.sendRedirect(res.encodeRedirectURL(initURL));
            }
        }
        catch (LoginException ex) {
            Exception e = authenticator.getLastExceptionOnValidateUser();
            if (e != null && e instanceof DisabledUserException) {
                req.setAttribute("invitationConfirmError", (Object)bundle.resolve("UIOAuthInvitationForm.message.userDisabled", new Object[0]));
            } else {
                req.setAttribute("invitationConfirmError", (Object)bundle.resolve("UIOAuthInvitationForm.message.loginFailure", new Object[0]));
            }
        }
        catch (Exception ex) {
            req.setAttribute("invitationConfirmError", (Object)bundle.resolve("UIOAuthInvitationForm.message.loginUnknowException", new Object[0]));
            this.log.warn((Object)"Exception while checking password of user", (Throwable)ex);
        }
        this.getContext().getRequestDispatcher("/login/jsp/oauth_invitation.jsp").forward((ServletRequest)req, (ServletResponse)res);
    }

    private void processCreateNewAccount(HttpServletRequest req, HttpServletResponse res, MessageResolver bundle, AuthenticationRegistry authReg, User portalUser) throws IOException, ServletException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        String password2 = req.getParameter("password2");
        String firstName = req.getParameter("firstName");
        String lastName = req.getParameter("lastName");
        String displayName = req.getParameter("displayName");
        String email = req.getParameter("email");
        portalUser.setUserName(username);
        portalUser.setPassword(password);
        portalUser.setFirstName(firstName);
        portalUser.setLastName(lastName);
        portalUser.setDisplayName(displayName);
        portalUser.setEmail(email);
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> errorFields = new HashSet<String>();
        OrganizationService orgService = this.getService(OrganizationService.class);
        this.validateUser(portalUser, password2, orgService, bundle, errors, errorFields);
        if (errors.size() == 0) {
            try {
                orgService.getUserHandler().createUser(portalUser, true);
                UserProfileHandler profileHandler = orgService.getUserProfileHandler();
                UserProfile newUserProfile = profileHandler.findUserProfileByName(portalUser.getUserName());
                if (newUserProfile == null) {
                    newUserProfile = orgService.getUserProfileHandler().createUserProfileInstance(portalUser.getUserName());
                }
                OAuthPrincipal oauthPrincipal = (OAuthPrincipal)authReg.getAttributeOfClient(req, "_authenticatedOAuthPrincipal");
                newUserProfile.setAttribute(oauthPrincipal.getOauthProviderType().getUserNameAttrName(), oauthPrincipal.getUserName());
                try {
                    profileHandler.saveUserProfile(newUserProfile, true);
                    authReg.removeAttributeOfClient(req, "_authenticatedPortalUser");
                    authReg.removeAttributeOfClient(req, "_authenticatedPortalUserDetected");
                    res.sendRedirect(this.getContext().getContextPath());
                    return;
                }
                catch (OAuthException gtnOAuthException) {
                    if (gtnOAuthException.getExceptionCode() == OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME) {
                        orgService.getUserHandler().removeUser(portalUser.getUserName(), true);
                        errors.add(bundle.resolve("UIAccountSocial.msg.failed-registration", gtnOAuthException.getExceptionAttribute("OAuthProviderUsername"), gtnOAuthException.getExceptionAttribute("OAuthProviderName")));
                    } else {
                        this.log.warn((Object)"Unknown oauth error", (Throwable)gtnOAuthException);
                        errors.add(bundle.resolve("UIAccountSocial.msg.oauth-error", new Object[0]));
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)"Exception when create new account for user", (Throwable)ex);
                errors.add(bundle.resolve("UIAccountInputSet.msg.fail.create.user", new Object[0]));
            }
        }
        req.setAttribute("register_errors", errors);
        req.setAttribute("register_error_fields", errorFields);
        this.getContext().getRequestDispatcher("/WEB-INF/jsp/login/oauth_register.jsp").forward((ServletRequest)req, (ServletResponse)res);
    }

    private void validateUser(User user, String password2, OrganizationService orgService, MessageResolver bundle, List<String> errorMessages, Set<String> errorFields) {
        MandatoryValidator mandatory = new MandatoryValidator();
        ResourceBundle rb = bundle.getBundle();
        String username = user.getUserName();
        UserConfigurableValidator validator = new UserConfigurableValidator("username", "ExpressionValidator.msg.value-invalid");
        this.validate("username", username, new Validator[]{mandatory, validator}, rb, errorMessages, errorFields);
        if (!errorFields.contains("username")) {
            try {
                if (orgService.getUserHandler().findUserByName(username, UserStatus.ANY) != null) {
                    errorFields.add("username");
                    errorMessages.add(bundle.resolve("UIAccountInputSet.msg.user-exist", username));
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Can not check username exist or not for: " + username));
            }
        }
        String password = user.getPassword();
        validator = new PasswordStringLengthValidator(Integer.valueOf(6), Integer.valueOf(30));
        this.validate("password", password, new Validator[]{mandatory, validator}, rb, errorMessages, errorFields);
        if (!errorFields.contains("password") && !password.equals(password2)) {
            errorMessages.add(bundle.resolve("UIAccountForm.msg.password-is-not-match", new Object[0]));
            errorFields.add("password2");
        }
        StringLengthValidator stringLength = new StringLengthValidator(Integer.valueOf(1), Integer.valueOf(45));
        validator = new PersonalNameValidator();
        String firstName = user.getFirstName();
        String lastName = user.getLastName();
        this.validate("firstName", firstName, new Validator[]{mandatory, stringLength, validator}, rb, errorMessages, errorFields);
        this.validate("lastName", lastName, new Validator[]{mandatory, stringLength, validator}, rb, errorMessages, errorFields);
        stringLength = new StringLengthValidator(Integer.valueOf(0), Integer.valueOf(90));
        validator = new UserConfigurableValidator("displayname", "gatein.validators.displayname", Boolean.valueOf(false));
        String displayName = user.getDisplayName();
        this.validate("displayName", displayName, new Validator[]{stringLength, validator}, rb, errorMessages, errorFields);
        validator = new UserConfigurableValidator("email");
        String email = user.getEmail();
        this.validate("emailAddress", email, new Validator[]{mandatory, validator}, rb, errorMessages, errorFields);
        if (!errorFields.contains("emailAddress")) {
            try {
                Query query = new Query();
                query.setEmail(email);
                ListAccess users = orgService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
                if (users != null && users.getSize() > 0) {
                    errorFields.add("emailAddress");
                    errorMessages.add(bundle.resolve("UIAccountInputSet.msg.email-exist", email));
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)("Can not check email exist or not for: " + email));
            }
        }
    }

    private void validate(String field, String value, Validator[] validators, final ResourceBundle bundle, List<String> errorMessages, Set<String> errorFields) {
        try {
            UIForm form = new UIForm(){

                public String getLabel(String label) throws Exception {
                    return this.getLabel(bundle, label);
                }
            };
            form.setId("UIRegisterForm");
            UIFormStringInput uiFormStringInput = new UIFormStringInput(field, field, value);
            form.addUIFormInput((UIFormInput)uiFormStringInput);
            for (Validator validator : validators) {
                validator.validate((UIFormInput)uiFormStringInput);
            }
        }
        catch (Exception e) {
            errorFields.add(field);
            if (e instanceof MessageException) {
                MessageException mex = (MessageException)e;
                AbstractApplicationMessage msg = mex.getDetailMessage();
                msg.setResourceBundle(bundle);
                errorMessages.add(msg.getMessage());
            }
            this.log.debug((Object)e);
            errorMessages.add(field + " error");
        }
    }

    public static class MessageResolver {
        private final ResourceBundle bundle;

        public MessageResolver(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        public String resolve(String key, Object ... args) {
            try {
                String message = this.bundle.getString(key);
                if (message != null && args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        Object messageArg = args[i];
                        if (messageArg == null) continue;
                        String arg = messageArg.toString();
                        message = message.replace("{" + i + "}", arg);
                    }
                }
                return message;
            }
            catch (Exception ex) {
                return key;
            }
        }

        public ResourceBundle getBundle() {
            return this.bundle;
        }
    }
}

