/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.oauth.service.OAuthRegistrationServices;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;

public class OAuthRegistrationServicesImpl
implements OAuthRegistrationServices {
    private static Log log = ExoLogger.getLogger(OAuthRegistrationServicesImpl.class);
    private final List<String> registerOnFly;
    private final OrganizationService orgService;
    private final IdentityManager identityManager;

    public OAuthRegistrationServicesImpl(InitParams initParams, OrganizationService orgService, IdentityManager identityManager) {
        ValueParam onFly = initParams.getValueParam("registerOnFly");
        String onFlyValue = onFly == null ? "" : onFly.getValue();
        this.registerOnFly = onFlyValue != null && !onFlyValue.isEmpty() ? Arrays.asList(onFlyValue.split(",")) : Collections.EMPTY_LIST;
        this.orgService = orgService;
        this.identityManager = identityManager;
    }

    @Override
    public boolean isRegistrationOnFly(OAuthProviderType<? extends AccessTokenContext> oauthProviderType) {
        return this.registerOnFly.contains(oauthProviderType.getKey());
    }

    @Override
    public User detectGateInUser(HttpServletRequest request, OAuthPrincipal<? extends AccessTokenContext> principal) {
        User foundUser;
        block9: {
            OAuthProviderType providerType = principal.getOauthProviderType();
            User gtnUser = providerType.getOauthPrincipalProcessor().convertToGateInUser(principal);
            String email = gtnUser.getEmail();
            String username = gtnUser.getUserName();
            foundUser = null;
            try {
                UserHandler userHandler = this.orgService.getUserHandler();
                Query query = null;
                ListAccess users = null;
                if (username != null) {
                    query = new Query();
                    query.setUserName(username);
                    users = userHandler.findUsersByQuery(query, UserStatus.ANY);
                    if (users != null && users.getSize() > 0) {
                        foundUser = ((User[])users.load(0, 1))[0];
                    }
                }
                if (foundUser == null && email != null && !email.isEmpty()) {
                    query = new Query();
                    query.setEmail(email);
                    users = userHandler.findUsersByQuery(query, UserStatus.ANY);
                    if (users != null && users.getSize() > 0) {
                        foundUser = ((User[])users.load(0, 1))[0];
                    }
                }
                Cookie[] cookies = request.getCookies();
                if (foundUser != null || cookies == null || cookies.length <= 0) break block9;
                for (Cookie cookie : cookies) {
                    if (!"last_login_username".equals(cookie.getName())) continue;
                    username = cookie.getValue();
                    if (username != null && username.length() > 0) {
                        query = new Query();
                        query.setUserName(username);
                        users = userHandler.findUsersByQuery(query, UserStatus.ANY);
                        if (users != null && users.getSize() > 0) {
                            foundUser = ((User[])users.load(0, 1))[0];
                        }
                    }
                    break;
                }
            }
            catch (Exception ex) {
                log.error((Object)"Exception when trying to detect user: ", (Throwable)ex);
            }
        }
        return foundUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createGateInUser(OAuthPrincipal<? extends AccessTokenContext> principal) {
        User user;
        block17: {
            OAuthProviderType providerType = principal.getOauthProviderType();
            user = providerType.getOauthPrincipalProcessor().convertToGateInUser(principal);
            user.setPassword(this.randomPassword(16));
            if (this.orgService instanceof ComponentRequestLifecycle) {
                RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.orgService));
            }
            try {
                this.orgService.getUserHandler().createUser(user, true);
                UserProfileHandler profileHandler = this.orgService.getUserProfileHandler();
                UserProfile newUserProfile = profileHandler.findUserProfileByName(user.getUserName());
                if (newUserProfile == null) {
                    newUserProfile = this.orgService.getUserProfileHandler().createUserProfileInstance(user.getUserName());
                }
                newUserProfile.setAttribute(providerType.getUserNameAttrName(), principal.getUserName());
                profileHandler.saveUserProfile(newUserProfile, true);
                String avatar = principal.getAvatar();
                if (avatar == null || avatar.trim().isEmpty()) break block17;
                int WIDTH = 200;
                int HEIGHT = 200;
                String fileName = FilenameUtils.getBaseName((String)avatar);
                MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                String mimeType = mimeTypeResolver.getMimeType(avatar);
                if (!mimeType.toLowerCase().contains("image")) {
                    mimeType = "image/png";
                }
                try {
                    URL url = new URL(avatar);
                    InputStream is = url.openStream();
                    if (is != null) {
                        AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)is, (int)WIDTH, (int)HEIGHT, null, (String)fileName, (String)mimeType, null);
                        if (avatarAttachment == null) {
                            avatarAttachment = new AvatarAttachment(null, fileName, mimeType, is, System.currentTimeMillis());
                        }
                        is.close();
                        Identity identity = this.identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
                        Profile p = identity.getProfile();
                        p.setProperty("avatar", (Object)avatarAttachment);
                        Map props = p.getProperties();
                        for (String key : props.keySet()) {
                            if (!key.startsWith("avatar_")) continue;
                            p.removeProperty(key);
                        }
                        this.identityManager.updateProfile(p);
                    }
                }
                catch (MalformedURLException ex) {
                    log.warn((Object)("Can not fetch Avatar of oauth user because the URL is invalid: " + avatar), (Throwable)ex);
                }
                catch (IOException ex) {
                    log.warn((Object)("Can not fetch Avatar at URL: " + avatar), (Throwable)ex);
                }
                catch (Exception ex) {
                    log.warn((Object)("Can not fetch Avatar at URL: " + avatar), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Exception when trying to create user: " + user.getUserName() + " on-fly"), (Throwable)ex);
                }
                user = null;
            }
            finally {
                if (this.orgService instanceof ComponentRequestLifecycle) {
                    RequestLifeCycle.end();
                }
            }
        }
        return user;
    }

    private String randomPassword(int length) {
        String CHAR_ENABLED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        char[] chars = new char[length];
        Random random = new Random();
        int len = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
        for (int i = 0; i < length; ++i) {
            int rand = random.nextInt(len) % len;
            chars[i] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(rand);
        }
        return new String(chars);
    }
}

