/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.htmlcleaner.BrowserCompactXmlSerializer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CompactHtmlSerializer;
import org.htmlcleaner.CompactXmlSerializer;
import org.htmlcleaner.ConfigFileTagProvider;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.PrettyHtmlSerializer;
import org.htmlcleaner.PrettyXmlSerializer;
import org.htmlcleaner.SimpleHtmlSerializer;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XPatherException;
import org.htmlcleaner.audit.HtmlModificationListenerLogger;

public class CommandLine {
    private static final String OMITXMLDECL = "omitxmldecl";
    private static final String className = CommandLine.class.getName();
    private static final Logger logger = Logger.getLogger(className);

    private static String getArgValue(String[] args, String name, String defaultValue) {
        for (String curr : args) {
            int eqIndex = curr.indexOf(61);
            if (eqIndex < 0) continue;
            String argName = curr.substring(0, eqIndex).trim();
            String argValue = curr.substring(eqIndex + 1).trim();
            if (!argName.toLowerCase().startsWith(name.toLowerCase())) continue;
            return argValue;
        }
        return defaultValue;
    }

    private static boolean toBoolean(String s) {
        return s != null && ("on".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s));
    }

    public static void main(String[] args) throws IOException, XPatherException {
        String outCharset;
        String inCharset;
        String source = CommandLine.getArgValue(args, "src", "");
        if ("".equals(source)) {
            System.err.println("Usage: java -jar htmlcleanerXX.jar src=<url | file> [incharset=<charset>] [dest=<file>] [outcharset=<charset>] [taginfofile=<file>] [options...]");
            System.err.println("");
            System.err.println("where options include:");
            System.err.println("    outputtype=simple* | compact | browser-compact | pretty");
            System.err.println("    advancedxmlescape=true* | false");
            System.err.println("    usecdata=true* | false");
            System.err.println("    specialentities=true* | false");
            System.err.println("    unicodechars=true* | false");
            System.err.println("    omitunknowntags=true | false*");
            System.err.println("    treatunknowntagsascontent=true | false*");
            System.err.println("    omitdeprtags=true | false*");
            System.err.println("    treatdeprtagsascontent=true | false*");
            System.err.println("    omitcomments=true | false*");
            System.err.println("    omitxmldecl=true* | false");
            System.err.println("    omitdoctypedecl=true* | false");
            System.err.println("    omithtmlenvelope=true | false*");
            System.err.println("    useemptyelementtags=true* | false");
            System.err.println("    allowmultiwordattributes=true* | false");
            System.err.println("    allowhtmlinsideattributes=true | false*");
            System.err.println("    ignoreqe=true | false*");
            System.err.println("    namespacesaware=true* | false");
            System.err.println("    hyphenreplacement=<string value> [=]");
            System.err.println("    prunetags=<string value> []");
            System.err.println("    booleanatts=self* | empty | true");
            System.err.println("    nodebyxpath=<xpath expression>");
            System.err.println("    t:<sourcetagX>[=<desttag>[,<preserveatts>]]");
            System.err.println("    t:<sourcetagX>.<destattrY>[=<template>]");
            System.exit(1);
        }
        if ("".equals(inCharset = CommandLine.getArgValue(args, "incharset", ""))) {
            inCharset = "UTF-8";
        }
        if ("".equals(outCharset = CommandLine.getArgValue(args, "outcharset", ""))) {
            outCharset = "UTF-8";
        }
        String destination = CommandLine.getArgValue(args, "dest", "");
        String outputType = CommandLine.getArgValue(args, "outputtype", "");
        String advancedXmlEscape = CommandLine.getArgValue(args, "advancedxmlescape", "");
        String useCData = CommandLine.getArgValue(args, "usecdata", "");
        String translateSpecialEntities = CommandLine.getArgValue(args, "specialentities", "");
        String unicodeChars = CommandLine.getArgValue(args, "unicodechars", "");
        String omitUnknownTags = CommandLine.getArgValue(args, "omitunknowntags", "");
        String treatUnknownTagsAsContent = CommandLine.getArgValue(args, "treatunknowntagsascontent", "");
        String omitDeprecatedTags = CommandLine.getArgValue(args, "omitdeprtags", "");
        String treatDeprecatedTagsAsContent = CommandLine.getArgValue(args, "treatdeprtagsascontent", "");
        String omitComments = CommandLine.getArgValue(args, "omitcomments", "");
        String omitXmlDeclaration = CommandLine.getArgValue(args, OMITXMLDECL, "");
        String omitDoctypeDeclaration = CommandLine.getArgValue(args, "omitdoctypedecl", "");
        String omitHtmlEnvelope = CommandLine.getArgValue(args, "omithtmlenvelope", "");
        String useEmptyElementTags = CommandLine.getArgValue(args, "useemptyelementtags", "");
        String allowMultiWordAttributes = CommandLine.getArgValue(args, "allowmultiwordattributes", "");
        String allowHtmlInsideAttributes = CommandLine.getArgValue(args, "allowhtmlinsideattributes", "");
        String ignoreQuestAndExclam = CommandLine.getArgValue(args, "ignoreqe", "");
        String namespacesAware = CommandLine.getArgValue(args, "namespacesaware", "");
        String commentHyphen = CommandLine.getArgValue(args, "hyphenreplacement", "");
        String pruneTags = CommandLine.getArgValue(args, "prunetags", "");
        String booleanAtts = CommandLine.getArgValue(args, "booleanatts", "");
        String nodeByXPath = CommandLine.getArgValue(args, "nodebyxpath", "");
        String tagInfoFile = CommandLine.getArgValue(args, "taginfofile", "");
        HtmlCleaner cleaner = !"".equals(tagInfoFile) ? new HtmlCleaner(new ConfigFileTagProvider(new File(tagInfoFile))) : new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        props.addHtmlModificationListener(new HtmlModificationListenerLogger(logger));
        if (!"".equals(omitUnknownTags)) {
            props.setOmitUnknownTags(CommandLine.toBoolean(omitUnknownTags));
        }
        if (!"".equals(treatUnknownTagsAsContent)) {
            props.setTreatUnknownTagsAsContent(CommandLine.toBoolean(treatUnknownTagsAsContent));
        }
        if (!"".equals(omitDeprecatedTags)) {
            props.setOmitDeprecatedTags(CommandLine.toBoolean(omitDeprecatedTags));
        }
        if (!"".equals(treatDeprecatedTagsAsContent)) {
            props.setTreatDeprecatedTagsAsContent(CommandLine.toBoolean(treatDeprecatedTagsAsContent));
        }
        if (!"".equals(advancedXmlEscape)) {
            props.setAdvancedXmlEscape(CommandLine.toBoolean(advancedXmlEscape));
        }
        if (!"".equals(useCData)) {
            props.setUseCdataForScriptAndStyle(CommandLine.toBoolean(useCData));
        }
        if (!"".equals(translateSpecialEntities)) {
            props.setTranslateSpecialEntities(CommandLine.toBoolean(translateSpecialEntities));
        }
        if (!"".equals(unicodeChars)) {
            props.setRecognizeUnicodeChars(CommandLine.toBoolean(unicodeChars));
        }
        if (!"".equals(omitComments)) {
            props.setOmitComments(CommandLine.toBoolean(omitComments));
        }
        if (!"".equals(omitXmlDeclaration)) {
            props.setOmitXmlDeclaration(CommandLine.toBoolean(omitXmlDeclaration));
        }
        if (!"".equals(omitDoctypeDeclaration)) {
            props.setOmitDoctypeDeclaration(CommandLine.toBoolean(omitDoctypeDeclaration));
        }
        if (!"".equals(omitHtmlEnvelope)) {
            props.setOmitHtmlEnvelope(CommandLine.toBoolean(omitHtmlEnvelope));
        }
        if (!"".equals(useEmptyElementTags)) {
            props.setUseEmptyElementTags(CommandLine.toBoolean(useEmptyElementTags));
        }
        if (!"".equals(allowMultiWordAttributes)) {
            props.setAllowMultiWordAttributes(CommandLine.toBoolean(allowMultiWordAttributes));
        }
        if (!"".equals(allowHtmlInsideAttributes)) {
            props.setAllowHtmlInsideAttributes(CommandLine.toBoolean(allowHtmlInsideAttributes));
        }
        if (!"".equals(ignoreQuestAndExclam)) {
            props.setIgnoreQuestAndExclam(CommandLine.toBoolean(ignoreQuestAndExclam));
        }
        if (!"".equals(namespacesAware)) {
            props.setNamespacesAware(CommandLine.toBoolean(namespacesAware));
        }
        if (!"".equals(commentHyphen)) {
            props.setHyphenReplacementInComment(commentHyphen);
        }
        if (!"".equals(pruneTags)) {
            props.setPruneTags(pruneTags);
        }
        if (!"".equals(booleanAtts)) {
            props.setBooleanAttributeValues(booleanAtts);
        }
        TreeMap<String, String> transInfos = new TreeMap<String, String>();
        for (String arg2 : args) {
            String arg = arg2;
            if (!arg.startsWith("t:") || arg.length() <= 2) continue;
            int index = (arg = arg.substring(2)).indexOf(61);
            String key = index <= 0 ? arg : arg.substring(0, index);
            String value = index <= 0 ? null : arg.substring(index + 1);
            transInfos.put(key, value);
        }
        cleaner.initCleanerTransformations(transInfos);
        long start = System.currentTimeMillis();
        String src = source.toLowerCase();
        TagNode node = src.startsWith("http://") || src.startsWith("https://") ? cleaner.clean(new URL(src), inCharset) : cleaner.clean(new File(src), inCharset);
        if (!"".equals(nodeByXPath)) {
            int i;
            Object[] xpathResult = node.evaluateXPath(nodeByXPath);
            for (i = 0; i < xpathResult.length; ++i) {
                if (!(xpathResult[i] instanceof TagNode)) continue;
                node = (TagNode)xpathResult[i];
                System.out.println("Node successfully found by XPath.");
                break;
            }
            if (i == xpathResult.length) {
                System.out.println("Node not found by XPath expression - whole html tree is going to be serialized!");
            }
        }
        OutputStream out = destination == null || "".equals(destination.trim()) ? System.out : new FileOutputStream(destination);
        if ("compact".equals(outputType)) {
            new CompactXmlSerializer(props).writeToStream(node, out, outCharset);
        } else if ("browser-compact".equals(outputType)) {
            new BrowserCompactXmlSerializer(props).writeToStream(node, out, outCharset);
        } else if ("pretty".equals(outputType)) {
            new PrettyXmlSerializer(props).writeToStream(node, out, outCharset);
        } else if ("htmlsimple".equals(outputType)) {
            new SimpleHtmlSerializer(props).writeToStream(node, out, outCharset);
        } else if ("htmlpretty".equals(outputType)) {
            new PrettyHtmlSerializer(props).writeToStream(node, out, outCharset);
        } else if ("htmlcompact".equals(outputType)) {
            new CompactHtmlSerializer(props).writeToStream(node, out, outCharset);
        } else {
            new SimpleXmlSerializer(props).writeToStream(node, out, outCharset);
        }
        System.out.println("Finished successfully in " + (System.currentTimeMillis() - start) + "ms.");
    }
}

