/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContainer;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateList;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/admin/template/UITemplatesManager.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})})
public class UITemplatesManager
extends UIAbstractManager {
    public static final String POPUP_TEMPLATE_ID = "TemplateContainerPopup";
    public static final String ACTIONS_TEMPLATE_ID = "UIActionsTemplateContainer";
    public static final String OTHERS_TEMPLATE_ID = "UIOthersTemplateContainer";
    public static final String ACTIONS_TEMPLATE_LIST_ID = "UIActionsTemplateList";
    public static final String OTHERS_TEMPLATE_LIST_ID = "UIOthersTemplateList";
    public static final String ACTIONS_ITERATOR_ID = "ActionsNodeTypeListIterator";
    public static final String OTHERS_ITERATOR_ID = "OthersNodeTypeListIterator";
    private String selectedTabId = "UITemplateContainer";

    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    public void setSelectedTab(String renderTabId) {
        this.selectedTabId = renderTabId;
    }

    public void setSelectedTab(int index) {
        this.selectedTabId = this.getChild(index - 1).getId();
    }

    public UITemplatesManager() throws Exception {
        UITemplateContainer uiTemp = (UITemplateContainer)this.addChild(UITemplateContainer.class, null, null);
        ((UITemplateList)uiTemp.getChild(UITemplateList.class)).setTemplateFilter("templates");
        UITemplateContainer uiActionsTemp = (UITemplateContainer)this.addChild(UITemplateContainer.class, null, ACTIONS_TEMPLATE_ID);
        ((UITemplateList)uiActionsTemp.getChild(UITemplateList.class)).setTemplateFilter("actions");
        ((UITemplateList)uiActionsTemp.getChild(UITemplateList.class)).setId(ACTIONS_TEMPLATE_LIST_ID);
        UITemplateContainer uiOthersTemp = (UITemplateContainer)this.addChild(UITemplateContainer.class, null, OTHERS_TEMPLATE_ID);
        ((UITemplateList)uiOthersTemp.getChild(UITemplateList.class)).setTemplateFilter("others");
        ((UITemplateList)uiOthersTemp.getChild(UITemplateList.class)).setId(OTHERS_TEMPLATE_LIST_ID);
        this.addChild(UIPopupWindow.class, null, POPUP_TEMPLATE_ID);
        this.addChild(UIPopupWindow.class, null, "TemplatePermission");
        this.setSelectedTab("UITemplateContainer");
    }

    public void initPopup(UIComponent uiComponent) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(POPUP_TEMPLATE_ID);
        uiPopup.setRendered(true);
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(600, 300);
        uiPopup.setUIComponent(uiComponent);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void initPopupPermission(String id, String membership) throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById("TemplatePermission");
        uiPopup.setWindowSize(560, 300);
        UIPermissionSelector uiECMPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
        uiECMPermission.setSelectedMembership(true);
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiECMPermission.setCurrentPermission("/" + arrMember[1]);
        }
        if (id.equals("AddNew")) {
            UITemplateForm uiForm = (UITemplateForm)this.findFirstComponentOfType(UITemplateForm.class);
            uiECMPermission.setSourceComponent((UIComponent)uiForm, null);
        } else {
            UITemplateContent uiTemContent = (UITemplateContent)this.findComponentById(id);
            uiECMPermission.setSourceComponent((UIComponent)uiTemContent, null);
        }
        uiPopup.setUIComponent((UIComponent)uiECMPermission);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public boolean isEditingTemplate() {
        UIECMAdminPortlet adminPortlet = (UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class);
        UIPopupContainer popupContainer = (UIPopupContainer)adminPortlet.getChild(UIPopupContainer.class);
        UIPopupWindow uiPopup = (UIPopupWindow)popupContainer.getChild(UIPopupWindow.class);
        uiPopup.setId(POPUP_TEMPLATE_ID);
        return uiPopup != null && uiPopup.isShow() && uiPopup.isRendered();
    }

    public void refresh() throws Exception {
        UITemplateContainer templateContainer = (UITemplateContainer)this.getChildById("UITemplateContainer");
        UITemplateContainer templateActionsContainer = (UITemplateContainer)this.getChildById(ACTIONS_TEMPLATE_ID);
        UITemplateContainer templateOthersContainer = (UITemplateContainer)this.getChildById(OTHERS_TEMPLATE_ID);
        ((UITemplateList)templateContainer.getChild(UITemplateList.class)).getUIPageIterator().setId(ACTIONS_ITERATOR_ID);
        ((UITemplateList)templateOthersContainer.getChild(UITemplateList.class)).getUIPageIterator().setId(OTHERS_ITERATOR_ID);
        templateContainer.update();
        templateActionsContainer.update();
        templateOthersContainer.update();
    }

    public static class CloseActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UITemplatesManager uiManager = (UITemplatesManager)((UIPopupWindow)event.getSource()).getAncestorOfType(UITemplatesManager.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChild(UIPopupWindow.class);
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class SelectTabActionListener
    extends EventListener<UITemplatesManager> {
        public void execute(Event<UITemplatesManager> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            ((UITemplatesManager)((Object)event.getSource())).setSelectedTab(renderTab);
            WebuiRequestContext parentContext = (WebuiRequestContext)context.getParentAppRequestContext();
            if (parentContext != null) {
                parentContext.setResponseComplete(true);
            } else {
                context.setResponseComplete(true);
            }
        }
    }
}

