/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.Log;

public class LogFilter
extends Filter<Log> {
    private final EthFilter ethFilter;

    public LogFilter(Web3j web3j, Callback<Log> callback, EthFilter ethFilter) {
        super(web3j, callback);
        this.ethFilter = ethFilter;
    }

    @Override
    org.web3j.protocol.core.methods.response.EthFilter sendRequest() throws IOException {
        return this.web3j.ethNewFilter(this.ethFilter).send();
    }

    @Override
    void process(List<EthLog.LogResult> logResults) {
        for (EthLog.LogResult logResult : logResults) {
            if (logResult instanceof EthLog.LogObject) {
                Log log = ((EthLog.LogObject)logResult).get();
                this.callback.onEvent(log);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + " required LogObject");
        }
    }

    @Override
    protected Optional<Request<?, EthLog>> getFilterLogs(BigInteger filterId) {
        return Optional.of(this.web3j.ethGetFilterLogs(filterId));
    }
}

