/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.email.entity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailDigestEntity;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailParamEntity;

@Entity(name="NotificationsMailNotifEntity")
@ExoEntity
@Table(name="NTF_EMAIL_NOTIFS")
@NamedQueries(value={@NamedQuery(name="NotificationsMailNotifEntity.getNotifsByPluginAndDay", query="SELECT distinct(m) FROM NotificationsMailNotifEntity m JOIN m.digests d LEFT OUTER JOIN FETCH m.parameters p WHERE DAY(m.creationDate)= :day AND MONTH(m.creationDate)= :month AND YEAR(m.creationDate)= :year AND m.type= :pluginId AND d.type= 'daily' ORDER BY m.order ASC, m.creationDate DESC"), @NamedQuery(name="NotificationsMailNotifEntity.getNotifsByPluginAndWeek", query="SELECT distinct(m) FROM NotificationsMailNotifEntity m JOIN m.digests d LEFT OUTER JOIN FETCH m.parameters p WHERE m.creationDate> :date AND m.type= :pluginId AND d.type= 'weekly' ORDER BY m.order ASC, m.creationDate DESC"), @NamedQuery(name="NotificationsMailNotifEntity.getAllNotificationsWithoutDigests", query="SELECT distinct(m) FROM NotificationsMailNotifEntity m WHERE m.digests IS EMPTY")})
public class MailNotifEntity {
    @Id
    @Column(name="EMAIL_NOTIF_ID")
    @SequenceGenerator(name="SEQ_NTF_EMAIL_NOTIF", sequenceName="SEQ_NTF_EMAIL_NOTIF", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NTF_EMAIL_NOTIF")
    private long id;
    @Column(name="SENDER")
    private String sender;
    @Column(name="TYPE")
    private String type;
    @Column(name="CREATION_DATE")
    private Calendar creationDate;
    @Column(name="SENDING_ORDER")
    private int order;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="notification")
    private List<MailDigestEntity> digests = new ArrayList<MailDigestEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="notification")
    private List<MailParamEntity> parameters = new ArrayList<MailParamEntity>();

    public long getId() {
        return this.id;
    }

    public String getSender() {
        return this.sender;
    }

    public MailNotifEntity setSender(String sender) {
        this.sender = StringUtils.isBlank((CharSequence)sender) ? null : sender;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public MailNotifEntity setType(String type) {
        this.type = type;
        return this;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public MailNotifEntity setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public MailNotifEntity setOrder(int order) {
        this.order = order;
        return this;
    }

    public List<MailParamEntity> getParameters() {
        return this.parameters;
    }

    public List<MailDigestEntity> getDigests() {
        return this.digests;
    }
}

