/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.login.LoginStatus;
import org.exoplatform.web.login.UIParamsExtension;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.web.security.sso.SSOHelper;
import org.gatein.common.text.EntityEncoder;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.authentication.AuthenticationEventType;
import org.gatein.wci.security.Credentials;
import org.json.JSONObject;

public class LoginHandler
extends JspBasedWebHandler {
    public static final String LOGIN_EXTENSION_NAME = "LoginExtension";
    private static final Log LOG = ExoLogger.getLogger(LoginHandler.class);
    private static final String TEXT_HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String JS_PATHS_PARAM = "paths";
    private static final String LOGIN_JSP_PATH_PARAM = "login.jsp.path";
    private static final String CASE_INSENSITIVE_PARAM = "username.case.insensitive";
    private static final String LOGIN_EXTENSION_JS_MODULES = "LoginExtension";
    private boolean caseInsensitive;
    private PortalContainer container;
    private AuthenticationRegistry authenticationRegistry;
    private OrganizationService organizationService;
    private PasswordRecoveryService passwordRecoveryService;
    private SSOHelper ssoHelper;
    private ServletContext servletContext;
    private String loginJspPath;

    public LoginHandler(PortalContainer container, OrganizationService organizationService, PasswordRecoveryService passwordRecoveryService, AuthenticationRegistry authenticationRegistry, LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService, SSOHelper ssoHelper, InitParams params) {
        super(localeConfigService, brandingService, javascriptConfigService, skinService);
        this.container = container;
        this.organizationService = organizationService;
        this.authenticationRegistry = authenticationRegistry;
        this.passwordRecoveryService = passwordRecoveryService;
        this.ssoHelper = ssoHelper;
        if (params != null) {
            if (params.containsKey((Object)LOGIN_JSP_PATH_PARAM)) {
                this.loginJspPath = params.getValueParam(LOGIN_JSP_PATH_PARAM).getValue();
            }
            if (params.containsKey((Object)CASE_INSENSITIVE_PARAM)) {
                this.caseInsensitive = Boolean.parseBoolean(params.getValueParam(CASE_INSENSITIVE_PARAM).getValue());
            }
        }
    }

    public String getHandlerName() {
        return "login";
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public void onInit(WebAppController controller, ServletConfig servletConfig) {
        this.servletContext = this.container.getPortalContext();
        ServletContainerFactory.getServletContainer().addAuthenticationListener(event -> {
            if (event.getType() == AuthenticationEventType.LOGIN) {
                this.authenticationRegistry.setCredentials(event.getRequest(), event.getCredentials());
            }
        });
    }

    public boolean execute(ControllerContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Encoding not supported", (Throwable)e);
        }
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        final String portalContextPath = this.servletContext.getContextPath();
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getContextPath() {
                return portalContextPath;
            }
        };
        StringBuilder loginPath = new StringBuilder(this.loginJspPath);
        LoginStatus status = LoginStatus.UNAUTHENTICATED;
        if (request.getRemoteUser() == null) {
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                if (username.contains("@")) {
                    String userNameByEmail = this.getUserNameByEmail(username, context, loginPath);
                    if (StringUtils.isBlank((CharSequence)userNameByEmail)) {
                        return true;
                    }
                    username = userNameByEmail;
                } else if (this.caseInsensitive) {
                    username = this.getExactUserName(username);
                }
                Credentials credentials = new Credentials(username, password);
                try {
                    ServletContainerFactory.getServletContainer().login(request, response, credentials);
                    LOG.debug("User {} authenticated successfuly.", new Object[]{username});
                    this.addRememberMeCookie(request, response, credentials);
                }
                catch (Exception e) {
                    LOG.debug("User {} authentication failed.", new Object[]{username, e});
                    status = LoginStatus.FAILED;
                }
            }
            if (request.getRemoteUser() != null) {
                status = LoginStatus.AUTHENTICATED;
            }
        } else {
            LOG.debug((Object)"User already authenticated. Will redirect to initialURI");
            status = LoginStatus.AUTHENTICATED;
        }
        String initialURI = this.getInitalUri(request);
        if (status == LoginStatus.AUTHENTICATED) {
            if (!response.isCommitted()) {
                response.sendRedirect(response.encodeRedirectURL(initialURI));
            }
        } else {
            this.handleSsoRequest(context, (HttpServletRequest)wrappedRequest, loginPath, status, initialURI);
        }
        return true;
    }

    private void handleSsoRequest(ControllerContext context, HttpServletRequest request, StringBuilder loginPath, LoginStatus status, String initialURI) throws Exception {
        boolean meetDisabledUser;
        HttpServletResponse response = context.getResponse();
        request.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
        String disabledUser = (String)request.getAttribute("_disabledUserName");
        boolean bl = meetDisabledUser = disabledUser != null;
        if (this.ssoHelper.skipJSPRedirection() && meetDisabledUser) {
            response.setContentType(TEXT_HTML_CONTENT_TYPE);
            request.setAttribute("", (Object)this.ssoHelper);
            this.servletContext.getRequestDispatcher("/WEB-INF/jsp/login/disabled.jsp").include((ServletRequest)request, (ServletResponse)response);
        } else if (this.ssoHelper.skipJSPRedirection()) {
            Object ssoRedirectUrl = request.getContextPath() + this.ssoHelper.getSSORedirectURLSuffix();
            ssoRedirectUrl = response.encodeRedirectURL((String)ssoRedirectUrl);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Redirected to SSO login URL: " + (String)ssoRedirectUrl));
            }
            response.sendRedirect((String)ssoRedirectUrl);
        } else {
            if (meetDisabledUser) {
                status = LoginStatus.DISABLED_USER;
            }
            response.setContentType(TEXT_HTML_CONTENT_TYPE);
            this.dispatch(context, loginPath.toString(), status);
        }
    }

    private String getUserNameByEmail(String email, ControllerContext context, StringBuilder loginPath) throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        if (userHandler != null) {
            Query emailQuery = new Query();
            emailQuery.setEmail(email);
            try {
                ListAccess users = userHandler.findUsersByQuery(emailQuery);
                if (users != null && users.getSize() > 0) {
                    return ((User[])users.load(0, 1))[0].getUserName();
                }
            }
            catch (RuntimeException e) {
                LOG.warn((Object)"Can not login with an email associated to many users");
                this.dispatch(context, loginPath.toString(), LoginStatus.MANY_USERS_WITH_SAME_EMAIL);
            }
            catch (Exception e) {
                LOG.warn((Object)"Can not get users by email", (Throwable)e);
                this.dispatch(context, loginPath.toString(), LoginStatus.FAILED);
            }
        }
        return null;
    }

    private void addRememberMeCookie(HttpServletRequest request, HttpServletResponse response, Credentials credentials) {
        String rememberme = request.getParameter("rememberme");
        if ("true".equals(rememberme) || "on".equals(rememberme)) {
            CookieTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
            String cookieToken = tokenService.createToken(credentials);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found a remember me request parameter, created a persistent token " + cookieToken + " for it and set it up in the next response"));
            }
            Cookie cookie = new Cookie("rememberme", cookieToken);
            cookie.setPath("/");
            cookie.setHttpOnly(true);
            cookie.setMaxAge((int)tokenService.getValidityTime());
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
        } else if ("true".equals(request.getSession().getAttribute("_rememberme"))) {
            CookieTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
            String cookieToken = tokenService.createToken(credentials);
            Cookie cookie = new Cookie("oauth_rememberme", cookieToken);
            cookie.setPath("/");
            cookie.setHttpOnly(true);
            cookie.setMaxAge((int)tokenService.getValidityTime());
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
            request.getSession().removeAttribute("_rememberme");
        }
    }

    private String getInitalUri(HttpServletRequest request) {
        String initialURI = request.getParameter("initialURI");
        if (initialURI == null || initialURI.length() == 0) {
            initialURI = request.getContextPath();
            LOG.debug((Object)("No initial URI found, will use default " + initialURI + " instead "));
        } else {
            LOG.debug((Object)("Found initial URI " + initialURI));
        }
        try {
            URI uri = new URI(initialURI);
            if (uri.getHost() != null && !uri.getHost().equals(request.getServerName())) {
                LOG.warn((Object)"Cannot redirect to an URI outside of the current host when using a login redirect. Redirecting to the portal context path instead.");
                initialURI = request.getContextPath();
            }
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)"Initial URI in login link is malformed. Redirecting to the portal context path instead.");
            initialURI = request.getContextPath();
        }
        return initialURI;
    }

    private String getExactUserName(String username) {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            User user = this.organizationService.getUserHandler().findUserByName(username);
            if (user != null) {
                username = user.getUserName();
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)("Error while retrieving user " + username + " from IDM stores "), (Throwable)exception);
        }
        finally {
            RequestLifeCycle.end();
        }
        return username;
    }

    private void dispatch(ControllerContext controllerContext, String dispatchPath, LoginStatus status) throws Exception {
        HttpServletRequest request = controllerContext.getRequest();
        HttpServletResponse response = controllerContext.getResponse();
        List<String> additionalJSModules = this.getExtendedJSModules(controllerContext, request);
        List<String> additionalCSSModules = Collections.singletonList("portal/login");
        super.prepareDispatch(controllerContext, "PORTLET/social-portlet/Login", additionalJSModules, additionalCSSModules, params -> this.extendUIParameters(controllerContext, status, (JSONObject)params));
        this.servletContext.getRequestDispatcher(dispatchPath).include((ServletRequest)request, (ServletResponse)response);
    }

    private List<String> getExtendedJSModules(ControllerContext controllerContext, HttpServletRequest request) throws Exception {
        ArrayList<String> additionalJSModules = new ArrayList<String>();
        JSONObject jsConfig = this.javascriptConfigService.getJSConfig(controllerContext, request.getLocale());
        if (jsConfig.has(JS_PATHS_PARAM)) {
            JSONObject jsConfigPaths = jsConfig.getJSONObject(JS_PATHS_PARAM);
            Iterator keys = jsConfigPaths.keys();
            while (keys.hasNext()) {
                String module = (String)keys.next();
                if (!module.contains("LoginExtension")) continue;
                additionalJSModules.add(module);
            }
        }
        return additionalJSModules;
    }

    private void extendUIParameters(ControllerContext controllerContext, LoginStatus status, JSONObject params) {
        HttpServletRequest request = controllerContext.getRequest();
        try {
            List paramsExtensions;
            String initialURI = this.getInitalUri(request);
            params.put("initialUri", (Object)EntityEncoder.FULL.encode(initialURI));
            String forgotPasswordPath = this.passwordRecoveryService.getPasswordRecoverURL(null, null);
            params.put("forgotPasswordPath", (Object)(request.getContextPath() + forgotPasswordPath));
            if (status != LoginStatus.AUTHENTICATED && status != LoginStatus.UNAUTHENTICATED) {
                params.put("errorCode", (Object)status.getErrorCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)(paramsExtensions = this.container.getComponentInstancesOfType(UIParamsExtension.class)))) {
                paramsExtensions.stream().filter(extension -> extension.getExtensionNames().contains("LoginExtension")).forEach(paramsExtension -> {
                    Map<String, Object> extendedParams = paramsExtension.extendParameters(controllerContext, "LoginExtension");
                    if (MapUtils.isNotEmpty(extendedParams)) {
                        extendedParams.forEach((key, value) -> {
                            try {
                                params.put(key, value);
                            }
                            catch (Exception e) {
                                LOG.warn("Error while adding {}/{} in login params map", new Object[]{key, value, e});
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while computing Login UI parameters", (Throwable)e);
        }
    }
}

