/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public class SimpleIdentifier
implements ReferenceIdentifier,
Deprecable,
Serializable {
    private static final long serialVersionUID = -3544709943777129514L;
    protected final Citation authority;
    protected final String code;
    protected final boolean isDeprecated;

    public SimpleIdentifier(Citation citation, String string, boolean bl) {
        this.authority = citation;
        this.code = string;
        this.isDeprecated = bl;
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public String getCodeSpace() {
        return Citations.toCodeSpace(this.authority);
    }

    public String getCode() {
        return this.code;
    }

    public String getVersion() {
        InternationalString internationalString;
        if (this.authority != null && (internationalString = this.authority.getEdition()) != null) {
            return internationalString.toString();
        }
        return null;
    }

    public InternationalString getDescription() {
        return null;
    }

    public InternationalString getRemarks() {
        return null;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            SimpleIdentifier simpleIdentifier = (SimpleIdentifier)object;
            return Objects.equals(this.code, simpleIdentifier.code) && Objects.equals(this.authority, simpleIdentifier.authority) && this.isDeprecated == simpleIdentifier.isDeprecated;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.code, this.isDeprecated) ^ 0x395E8BD6;
    }

    public final String toString() {
        String string = Classes.getShortClassName((Object)this);
        StringBuilder stringBuilder = new StringBuilder(string.length() + CharSequences.length((CharSequence)this.code) + 10);
        stringBuilder.append(string).append('[');
        String string2 = this.getCodeSpace();
        boolean bl = false;
        if (string2 != null) {
            stringBuilder.append('\u201c').append(string2);
            bl = true;
        }
        if (this.code != null) {
            stringBuilder.append(bl ? (char)':' : '\u201c').append(this.code);
            bl = true;
        }
        if (bl) {
            stringBuilder.append('\u201d');
        }
        this.appendStringTo(stringBuilder);
        return stringBuilder.append(']').toString();
    }

    protected void appendStringTo(StringBuilder stringBuilder) {
    }
}

