/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.ArrayEnvelope;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.geometry.UnmodifiableGeometryException;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

@XmlTransient
public abstract class AbstractEnvelope
extends FormattableObject
implements Envelope,
Emptiable {
    private static final Envelope[] EMPTY = new Envelope[0];

    protected AbstractEnvelope() {
    }

    public static AbstractEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof AbstractEnvelope) {
            return (AbstractEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    static boolean equalsIgnoreMetadata(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) {
        return coordinateReferenceSystem == null || coordinateReferenceSystem2 == null || Utilities.deepEquals((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2, (ComparisonMode)(bl ? ComparisonMode.DEBUG : ComparisonMode.IGNORE_METADATA));
    }

    static CoordinateReferenceSystem getCommonCRS(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedReferenceSystemException {
        ArgumentChecks.ensureNonNull((String)"lowerCorner", (Object)directPosition);
        ArgumentChecks.ensureNonNull((String)"upperCorner", (Object)directPosition2);
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem2 = directPosition2.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            return coordinateReferenceSystem2;
        }
        if (coordinateReferenceSystem2 != null && !coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
            throw new MismatchedReferenceSystemException(Errors.format((short)78));
        }
        return coordinateReferenceSystem;
    }

    static CoordinateSystemAxis getAxis(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            return coordinateSystem.getAxis(n);
        }
        return null;
    }

    static boolean isWrapAround(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        return AbstractEnvelope.isWrapAround(AbstractEnvelope.getAxis(coordinateReferenceSystem, n));
    }

    static boolean isWrapAround(CoordinateSystemAxis coordinateSystemAxis) {
        return coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning());
    }

    static double getSpan(CoordinateSystemAxis coordinateSystemAxis) {
        if (AbstractEnvelope.isWrapAround(coordinateSystemAxis)) {
            return coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
        }
        return Double.NaN;
    }

    static boolean isNegativeUnsafe(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) != 0L;
    }

    public DirectPosition getLowerCorner() {
        return new LowerCorner();
    }

    public DirectPosition getUpperCorner() {
        return new UpperCorner();
    }

    public DirectPosition getMedian() {
        return new Median();
    }

    public abstract double getLower(int var1) throws IndexOutOfBoundsException;

    public abstract double getUpper(int var1) throws IndexOutOfBoundsException;

    public double getMinimum(int n) throws IndexOutOfBoundsException {
        double d = this.getLower(n);
        if (MathFunctions.isNegative((double)(this.getUpper(n) - d))) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
            d = AbstractEnvelope.isWrapAround(coordinateSystemAxis) ? coordinateSystemAxis.getMinimumValue() : Double.NaN;
        }
        return d;
    }

    public double getMaximum(int n) throws IndexOutOfBoundsException {
        double d = this.getUpper(n);
        if (MathFunctions.isNegative((double)(d - this.getLower(n)))) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
            d = AbstractEnvelope.isWrapAround(coordinateSystemAxis) ? coordinateSystemAxis.getMaximumValue() : Double.NaN;
        }
        return d;
    }

    public double getMedian(int n) throws IndexOutOfBoundsException {
        double d = this.getLower(n);
        double d2 = this.getUpper(n);
        double d3 = 0.5 * (d + d2);
        if (MathFunctions.isNegative((double)(d2 - d))) {
            d3 = AbstractEnvelope.fixMedian(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n), d3);
        }
        return d3;
    }

    static double fixMedian(CoordinateSystemAxis coordinateSystemAxis, double d) {
        if (AbstractEnvelope.isWrapAround(coordinateSystemAxis)) {
            double d2 = coordinateSystemAxis.getMinimumValue();
            double d3 = coordinateSystemAxis.getMaximumValue();
            double d4 = d3 - d2;
            if (d4 > 0.0 && d4 != Double.POSITIVE_INFINITY) {
                return d + 0.5 * Math.copySign(d4, 0.5 * (d2 + d3) - d);
            }
        }
        return Double.NaN;
    }

    public double getSpan(int n) {
        double d = this.getUpper(n) - this.getLower(n);
        if (MathFunctions.isNegative((double)d)) {
            d = AbstractEnvelope.fixSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n), d);
        }
        return d;
    }

    static double fixSpan(CoordinateSystemAxis coordinateSystemAxis, double d) {
        double d2;
        if (AbstractEnvelope.isWrapAround(coordinateSystemAxis) && (d2 = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue()) > 0.0 && d2 != Double.POSITIVE_INFINITY && (d += d2) >= 0.0) {
            return d;
        }
        return Double.NaN;
    }

    public double getSpan(int n, Unit<?> unit) throws IndexOutOfBoundsException, IncommensurableException {
        Unit unit2;
        double d = this.getSpan(n);
        CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
        if (coordinateSystemAxis != null && (unit2 = coordinateSystemAxis.getUnit()) != null) {
            d = unit2.getConverterToAny(unit).convert(d);
        }
        return d;
    }

    public Envelope[] toSimpleEnvelopes() {
        int n;
        long l = 0L;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        int n2 = this.getDimension();
        for (n = 0; n != n2; ++n) {
            double d = this.getUpper(n) - this.getLower(n);
            if (d > 0.0) continue;
            if (!MathFunctions.isNegative((double)d)) {
                return EMPTY;
            }
            if (coordinateReferenceSystem == null) {
                coordinateReferenceSystem = this.getCoordinateReferenceSystem();
            }
            if (!AbstractEnvelope.isWrapAround(coordinateReferenceSystem, n)) {
                return EMPTY;
            }
            if (n >= 64) {
                throw new IllegalStateException(Errors.format((short)36, (Object)"axis", (Object)n2));
            }
            l |= 1L << n;
        }
        n = Long.bitCount(l);
        if (n >= 31) {
            throw new IllegalStateException(Errors.format((short)36, (Object)"wraparound", (Object)n));
        }
        Envelope[] envelopeArray = new Envelope[1 << n];
        if (envelopeArray.length == 1) {
            envelopeArray[0] = this;
        } else {
            int n3;
            Object object;
            int n4;
            double[] dArray = new double[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = this.getLower(i);
                dArray[i + n2] = this.getUpper(i);
            }
            double[][] dArrayArray = new double[envelopeArray.length][];
            for (n4 = 0; n4 < envelopeArray.length; ++n4) {
                object = new GeneralEnvelope(n4 == 0 ? dArray : (double[])dArray.clone());
                object.crs = coordinateReferenceSystem;
                envelopeArray[n4] = object;
                dArrayArray[n4] = object.coordinates;
            }
            n4 = 1;
            object = coordinateReferenceSystem.getCoordinateSystem();
            while ((n3 = Long.numberOfTrailingZeros(l)) != 64) {
                CoordinateSystemAxis coordinateSystemAxis = object.getAxis(n3);
                double d = coordinateSystemAxis.getMinimumValue();
                double d2 = coordinateSystemAxis.getMaximumValue();
                for (int i = 0; i < dArrayArray.length; ++i) {
                    dArray = dArrayArray[i];
                    if ((i & n4) == 0) {
                        dArray[n3 + n2] = d2;
                        continue;
                    }
                    dArray[n3] = d;
                }
                n4 <<= 1;
                l &= 1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return envelopeArray;
    }

    public boolean isEmpty() {
        int n = this.getDimension();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getSpan(i) > 0.0) continue;
            return true;
        }
        assert (!this.isAllNaN()) : this;
        return false;
    }

    public boolean isAllNaN() {
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.getLower(i)) && Double.isNaN(this.getUpper(i))) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    public boolean contains(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.getDimension();
        ArgumentChecks.ensureDimensionMatches((String)"point", (int)n, (DirectPosition)directPosition);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), directPosition.getCoordinateReferenceSystem(), true)) : directPosition;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            double d = directPosition.getOrdinate(i);
            double d2 = this.getLower(i);
            double d3 = this.getUpper(i);
            boolean bl2 = d >= d2;
            boolean bl3 = bl = d <= d3;
            if (bl2 & bl || bl2 | bl && MathFunctions.isNegative((double)(d3 - d2))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope) throws MismatchedDimensionException {
        return this.contains(envelope, true);
    }

    public boolean contains(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)n, (Envelope)envelope);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            double d = this.getLower(i);
            double d2 = this.getUpper(i);
            double d3 = directPosition.getOrdinate(i);
            double d4 = directPosition2.getOrdinate(i);
            if (bl) {
                bl3 = d3 >= d;
                bl2 = d4 <= d2;
            } else {
                bl3 = d3 > d;
                boolean bl4 = bl2 = d4 < d2;
            }
            if (bl3 & bl2 ? !AbstractEnvelope.isNegativeUnsafe(d4 - d3) || AbstractEnvelope.isNegativeUnsafe(d2 - d) || d == Double.NEGATIVE_INFINITY && d2 == Double.POSITIVE_INFINITY || d2 - d >= AbstractEnvelope.getSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), i)) : (bl3 != bl2 ? MathFunctions.isNegative((double)(d2 - d)) && (MathFunctions.isPositive((double)(d4 - d3)) || bl && Double.doubleToRawLongBits(d) == 0L && Double.doubleToRawLongBits(d2) == Long.MIN_VALUE) : MathFunctions.isNegativeZero((double)(d2 - d)))) continue;
            return false;
        }
        assert (envelope.getClass() == ArrayEnvelope.class || this.intersects(new ArrayEnvelope(envelope), bl)) : envelope;
        return true;
    }

    public boolean intersects(Envelope envelope) throws MismatchedDimensionException {
        return this.intersects(envelope, false);
    }

    public boolean intersects(Envelope envelope, boolean bl) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)n, (Envelope)envelope);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            double d = this.getLower(i);
            double d2 = this.getUpper(i);
            double d3 = directPosition.getOrdinate(i);
            double d4 = directPosition2.getOrdinate(i);
            if (bl) {
                bl5 = d3 <= d2;
                bl4 = d4 >= d;
            } else {
                bl5 = d3 < d2;
                boolean bl6 = bl4 = d4 > d;
            }
            if (bl4 & bl5 || (bl3 = MathFunctions.isNegative((double)(d2 - d))) | (bl2 = MathFunctions.isNegative((double)(d4 - d3))) && bl3 & bl2 | (bl4 | bl5)) continue;
            assert (envelope.getClass() == ArrayEnvelope.class || AbstractEnvelope.hasNaN(envelope) || !this.contains(new ArrayEnvelope(envelope), bl)) : envelope;
            return false;
        }
        return true;
    }

    static boolean hasNaN(Envelope envelope) {
        return AbstractEnvelope.hasNaN(envelope.getLowerCorner()) || AbstractEnvelope.hasNaN(envelope.getUpperCorner());
    }

    static boolean hasNaN(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        while (--n >= 0) {
            if (!Double.isNaN(directPosition.getOrdinate(n))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Envelope envelope, double d, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"other", (Object)envelope);
        int n = this.getDimension();
        if (envelope.getDimension() != n || !AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), false)) {
            return false;
        }
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = d;
            if (bl && (d2 = Math.max(this.getSpan(i), envelope.getSpan(i))) > 0.0 && d2 < Double.POSITIVE_INFINITY) {
                d3 *= d2;
            }
            if (MathFunctions.epsilonEqual((double)this.getLower(i), (double)directPosition.getOrdinate(i), (double)d3) && MathFunctions.epsilonEqual((double)this.getUpper(i), (double)directPosition2.getOrdinate(i), (double)d3)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AbstractEnvelope abstractEnvelope = (AbstractEnvelope)object;
            int n = this.getDimension();
            if (n == abstractEnvelope.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Double.doubleToLongBits(this.getLower(i)) == Double.doubleToLongBits(abstractEnvelope.getLower(i)) && Double.doubleToLongBits(this.getUpper(i)) == Double.doubleToLongBits(abstractEnvelope.getUpper(i))) continue;
                    assert (!this.equals(abstractEnvelope, 0.0, false)) : this;
                    return false;
                }
                if (Objects.equals(this.getCoordinateReferenceSystem(), abstractEnvelope.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == abstractEnvelope.hashCode()) : this;
                    assert (this.equals(abstractEnvelope, 0.0, false)) : this;
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.getDimension();
        int n2 = 1;
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                n2 = n2 * 31 + Double.hashCode(bl ? this.getLower(i) : this.getUpper(i));
            }
        } while (!(bl = !bl));
        return n2 + Objects.hashCode(this.getCoordinateReferenceSystem());
    }

    @Override
    public String toString() {
        return AbstractEnvelope.toString(this, false);
    }

    static String toString(Envelope envelope, boolean bl) {
        int n = envelope.getDimension();
        StringBuilder stringBuilder = new StringBuilder(64).append("BOX");
        if (n != 2) {
            stringBuilder.append(n).append('D');
        }
        if (n == 0) {
            stringBuilder.append("()");
        } else {
            DirectPosition directPosition = envelope.getLowerCorner();
            DirectPosition directPosition2 = envelope.getUpperCorner();
            boolean bl2 = false;
            do {
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((char)(i == 0 && !bl2 ? 40 : 32));
                    double d = (bl2 ? directPosition2 : directPosition).getOrdinate(i);
                    if (bl) {
                        stringBuilder.append((float)d);
                    } else {
                        stringBuilder.append(d);
                    }
                    StringBuilders.trimFractionalPart((StringBuilder)stringBuilder);
                }
                stringBuilder.append(bl2 ? (char)')' : ',');
            } while (bl2 = !bl2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Vector[] vectorArray = new Vector[]{Vector.create((double[])this.getLowerCorner().getCoordinate()), Vector.create((double[])this.getUpperCorner().getCoordinate())};
        formatter.append(vectorArray, WKTUtilities.suggestFractionDigits(this.getCoordinateReferenceSystem(), vectorArray));
        int n = this.getDimension();
        String string = "Box";
        if (n != 2) {
            string = string + n + 'D';
        }
        formatter.setInvalidWKT(Envelope.class, null);
        return string;
    }

    void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        throw new UnmodifiableGeometryException(Errors.format((short)153, this.getClass()));
    }

    private final class Median
    extends Point {
        private static final long serialVersionUID = -5826011018957321729L;

        private Median() {
        }

        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getMedian(n);
        }

        public void setOrdinate(int n, double d) {
            throw new UnmodifiableGeometryException(Errors.format((short)153, this.getClass()));
        }
    }

    private final class UpperCorner
    extends Point {
        private static final long serialVersionUID = -6458663549974061472L;

        private UpperCorner() {
        }

        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getUpper(n);
        }

        public void setOrdinate(int n, double d) {
            AbstractEnvelope.this.setRange(n, AbstractEnvelope.this.getLower(n), d);
        }
    }

    private final class LowerCorner
    extends Point {
        private static final long serialVersionUID = 1310741484466506178L;

        private LowerCorner() {
        }

        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getLower(n);
        }

        public void setOrdinate(int n, double d) {
            AbstractEnvelope.this.setRange(n, d, AbstractEnvelope.this.getUpper(n));
        }
    }

    private abstract class Point
    extends AbstractDirectPosition
    implements Serializable {
        private static final long serialVersionUID = -4868610696294317932L;

        private Point() {
        }

        public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractEnvelope.this.getCoordinateReferenceSystem();
        }

        public final int getDimension() {
            return AbstractEnvelope.this.getDimension();
        }
    }
}

