/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class EnvelopeReducer {
    static final EnvelopeReducer UNION = new EnvelopeReducer("union");
    static final EnvelopeReducer INTERSECT = new EnvelopeReducer("intersect"){

        @Override
        void reduce(GeneralEnvelope generalEnvelope, Envelope envelope) {
            generalEnvelope.intersect(envelope);
        }

        @Override
        void reduce(DefaultGeographicBoundingBox defaultGeographicBoundingBox, GeographicBoundingBox geographicBoundingBox) {
            defaultGeographicBoundingBox.intersect(geographicBoundingBox);
        }
    };
    private final String caller;

    EnvelopeReducer(String string) {
        this.caller = string;
    }

    void reduce(GeneralEnvelope generalEnvelope, Envelope envelope) {
        generalEnvelope.add(envelope);
    }

    void reduce(DefaultGeographicBoundingBox defaultGeographicBoundingBox, GeographicBoundingBox geographicBoundingBox) {
        defaultGeographicBoundingBox.add(geographicBoundingBox);
    }

    final GeneralEnvelope reduce(Envelope[] referencingServices) throws TransformException {
        Envelope envelope2;
        GeneralEnvelope[] generalEnvelopeArray = new GeneralEnvelope[((Envelope[])referencingServices).length];
        int n = 0;
        block4: for (Envelope envelope2 : referencingServices) {
            if (envelope2 == null) continue;
            CoordinateReferenceSystem coordinateReferenceSystem = envelope2.getCoordinateReferenceSystem();
            for (int i = 0; i < n; ++i) {
                GeneralEnvelope generalEnvelope = generalEnvelopeArray[i];
                if (!Utilities.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)generalEnvelope.getCoordinateReferenceSystem())) continue;
                this.reduce(generalEnvelope, envelope2);
                continue block4;
            }
            generalEnvelopeArray[n++] = new GeneralEnvelope(envelope2);
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return generalEnvelopeArray[0];
            }
        }
        ReferencingServices referencingServices2 = ReferencingServices.getInstance();
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[n];
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
        envelope2 = null;
        for (int i = 0; i < n; ++i) {
            GeneralEnvelope generalEnvelope = generalEnvelopeArray[i];
            coordinateReferenceSystemArray[i] = generalEnvelope.getCoordinateReferenceSystem();
            if (referencingServices2.setBounds((Envelope)generalEnvelope, defaultGeographicBoundingBox, this.caller) == null) continue;
            if (envelope2 == null) {
                envelope2 = defaultGeographicBoundingBox;
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                continue;
            }
            this.reduce((DefaultGeographicBoundingBox)envelope2, (GeographicBoundingBox)defaultGeographicBoundingBox);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = CRS.suggestCommonTarget((GeographicBoundingBox)envelope2, coordinateReferenceSystemArray);
        if (coordinateReferenceSystem == null) {
            throw new TransformException(Resources.format((short)82));
        }
        GeneralEnvelope generalEnvelope = null;
        for (int i = 0; i < n; ++i) {
            Envelope envelope3 = Envelopes.transform(generalEnvelopeArray[i], coordinateReferenceSystem);
            if (generalEnvelope == null) {
                generalEnvelope = GeneralEnvelope.castOrCopy(envelope3);
                continue;
            }
            this.reduce(generalEnvelope, envelope3);
        }
        return generalEnvelope;
    }
}

