/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.j2d;

import java.awt.geom.Rectangle2D;
import org.apache.sis.internal.util.Strings;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;

public class IntervalRectangle
extends Rectangle2D {
    public double xmin;
    public double ymin;
    public double xmax;
    public double ymax;

    public IntervalRectangle() {
    }

    public IntervalRectangle(Envelope envelope) {
        this.xmin = envelope.getMinimum(0);
        this.xmax = envelope.getMaximum(0);
        this.ymin = envelope.getMinimum(1);
        this.ymax = envelope.getMaximum(1);
    }

    public IntervalRectangle(DirectPosition directPosition, DirectPosition directPosition2) {
        this.xmin = directPosition.getOrdinate(0);
        this.xmax = directPosition2.getOrdinate(0);
        this.ymin = directPosition.getOrdinate(1);
        this.ymax = directPosition2.getOrdinate(1);
    }

    public IntervalRectangle(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d3;
        this.ymax = d4;
    }

    @Override
    public final boolean isEmpty() {
        return !(this.xmin < this.xmax) || !(this.ymin < this.ymax);
    }

    @Override
    public final double getX() {
        return this.xmin;
    }

    @Override
    public final double getY() {
        return this.ymin;
    }

    @Override
    public final double getWidth() {
        return this.xmax - this.xmin;
    }

    @Override
    public final double getHeight() {
        return this.ymax - this.ymin;
    }

    @Override
    public final double getMinX() {
        return this.xmin;
    }

    @Override
    public final double getMinY() {
        return this.ymin;
    }

    @Override
    public final double getMaxX() {
        return this.xmax;
    }

    @Override
    public final double getMaxY() {
        return this.ymax;
    }

    @Override
    public final double getCenterX() {
        return (this.xmin + this.xmax) * 0.5;
    }

    @Override
    public final double getCenterY() {
        return (this.ymin + this.ymax) * 0.5;
    }

    @Override
    public final void setRect(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d + d3;
        this.ymax = d2 + d4;
    }

    @Override
    public final void setRect(Rectangle2D rectangle2D) {
        if (rectangle2D != this) {
            this.xmin = rectangle2D.getMinX();
            this.ymin = rectangle2D.getMinY();
            this.xmax = rectangle2D.getMaxX();
            this.ymax = rectangle2D.getMaxY();
        }
    }

    @Override
    public final void setFrame(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D);
    }

    @Override
    public final boolean intersects(double d, double d2, double d3, double d4) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && d3 > 0.0 && d4 > 0.0)) {
            return false;
        }
        return d < this.xmax && d2 < this.ymax && d + d3 > this.xmin && d2 + d4 > this.ymin;
    }

    @Override
    public final boolean intersects(Rectangle2D rectangle2D) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        if (!(d2 > d)) {
            return false;
        }
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        if (!(d4 > d3)) {
            return false;
        }
        return d < this.xmax && d3 < this.ymax && d2 > this.xmin && d4 > this.ymin;
    }

    @Override
    public final boolean contains(double d, double d2, double d3, double d4) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && d3 > 0.0 && d4 > 0.0)) {
            return false;
        }
        return d >= this.xmin && d2 >= this.ymin && d + d3 <= this.xmax && d2 + d4 <= this.ymax;
    }

    @Override
    public final boolean contains(Rectangle2D rectangle2D) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        if (!(d2 > d)) {
            return false;
        }
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        if (!(d4 > d3)) {
            return false;
        }
        return d >= this.xmin && d3 >= this.ymin && d2 <= this.xmax && d4 <= this.ymax;
    }

    @Override
    public final boolean contains(double d, double d2) {
        return d >= this.xmin && d2 >= this.ymin && d < this.xmax && d2 < this.ymax;
    }

    @Override
    public final int outcode(double d, double d2) {
        int n = 0;
        if (!(this.xmax > this.xmin)) {
            n |= 5;
        } else if (d < this.xmin) {
            n |= 1;
        } else if (d > this.xmax) {
            n |= 4;
        }
        if (!(this.ymax > this.ymin)) {
            n |= 0xA;
        } else if (d2 < this.ymin) {
            n |= 2;
        } else if (d2 > this.ymax) {
            n |= 8;
        }
        return n;
    }

    public final void intersect(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = rectangle2D.getMinX();
        if (d4 > this.xmin) {
            this.xmin = d5;
        }
        d5 = rectangle2D.getMaxX();
        if (d3 < this.xmax) {
            this.xmax = d5;
        }
        d5 = rectangle2D.getMinY();
        if (d2 > this.ymin) {
            this.ymin = d5;
        }
        d5 = rectangle2D.getMaxY();
        if (d < this.ymax) {
            this.ymax = d5;
        }
    }

    @Override
    public final Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        IntervalRectangle intervalRectangle = new IntervalRectangle();
        intervalRectangle.xmin = Math.max(this.xmin, rectangle2D.getMinX());
        intervalRectangle.ymin = Math.max(this.ymin, rectangle2D.getMinY());
        intervalRectangle.xmax = Math.min(this.xmax, rectangle2D.getMaxX());
        intervalRectangle.ymax = Math.min(this.ymax, rectangle2D.getMaxY());
        return intervalRectangle;
    }

    @Override
    public final Rectangle2D createUnion(Rectangle2D rectangle2D) {
        IntervalRectangle intervalRectangle = new IntervalRectangle();
        intervalRectangle.xmin = Math.min(this.xmin, rectangle2D.getMinX());
        intervalRectangle.ymin = Math.min(this.ymin, rectangle2D.getMinY());
        intervalRectangle.xmax = Math.max(this.xmax, rectangle2D.getMaxX());
        intervalRectangle.ymax = Math.max(this.ymax, rectangle2D.getMaxY());
        return intervalRectangle;
    }

    @Override
    public final void add(double d, double d2) {
        if (d < this.xmin) {
            this.xmin = d;
        }
        if (d > this.xmax) {
            this.xmax = d;
        }
        if (d2 < this.ymin) {
            this.ymin = d2;
        }
        if (d2 > this.ymax) {
            this.ymax = d2;
        }
    }

    @Override
    public final void add(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = rectangle2D.getMinX();
        if (d4 < this.xmin) {
            this.xmin = d5;
        }
        d5 = rectangle2D.getMaxX();
        if (d3 > this.xmax) {
            this.xmax = d5;
        }
        d5 = rectangle2D.getMinY();
        if (d2 < this.ymin) {
            this.ymin = d5;
        }
        d5 = rectangle2D.getMaxY();
        if (d > this.ymax) {
            this.ymax = d5;
        }
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"xmin", this.xmin, "ymin", this.ymin, "xmax", this.xmax, "ymax", this.ymax});
    }
}

