/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class MathTransformParser
extends AbstractParser {
    static final String[] ID_KEYWORDS = new String[]{"Id", "Authority"};
    private static final String[] UNIT_KEYWORDS = new String[]{"Unit", "LengthUnit", "AngleUnit", "ScaleUnit", "TimeUnit", "ParametricUnit"};
    private static final Unit<?>[] BASE_UNITS = new Unit[]{Units.METRE, Units.RADIAN, Units.UNITY, Units.SECOND};
    private static final double[][] CONVERSION_FACTORS = new double[][]{{0.3048, 0.30480060960121924, 1609.3472186944375}, {4.84813681109536E-6, 2.908882086657216E-4, 0.015707963267948967, Math.PI / 180}};
    final ReferencingFactoryContainer factories;
    private transient String classification;
    private transient OperationMethod lastMethod;

    public MathTransformParser(MathTransformFactory mathTransformFactory) {
        this(Symbols.getDefault(), Collections.emptyMap(), null, null, null, new ReferencingFactoryContainer(null, null, null, null, null, mathTransformFactory), null);
    }

    MathTransformParser(Symbols symbols, Map<String, Element> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, ReferencingFactoryContainer referencingFactoryContainer, Locale locale) {
        super(symbols, map, numberFormat, dateFormat, unitFormat, locale);
        this.factories = referencingFactoryContainer;
        ArgumentChecks.ensureNonNull((String)"factories", (Object)referencingFactoryContainer);
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory";
    }

    @Override
    Object parseObject(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean bl) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        MathTransform mathTransform = this.parseParamMT(element);
        if (mathTransform == null && (mathTransform = this.parseConcatMT(element)) == null && (mathTransform = this.parseInverseMT(element)) == null && (mathTransform = this.parsePassThroughMT(element)) == null && bl) {
            throw element.missingOrUnknownComponent("Param_MT");
        }
        return mathTransform;
    }

    final Unit<?> parseUnitID(Element element) throws ParseException {
        Element element2 = element.pullElement(1, ID_KEYWORDS);
        if (element2 != null) {
            String string = element2.pullString("codeSpace");
            Object object = element2.pullObject("code");
            element2.close(this.ignoredElements);
            if ("EPSG".equalsIgnoreCase(string)) {
                try {
                    int n = Numbers.isInteger(object.getClass()) ? ((Number)object).intValue() : Integer.parseInt(object.toString());
                    return Units.valueOfEPSG((int)n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.warning(element, element2, null, (Exception)numberFormatException);
                }
            }
        }
        return null;
    }

    final Unit<?> parseUnit(Element element) throws ParseException {
        Element element2 = element.pullElement(1, UNIT_KEYWORDS);
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("factor");
        int n = element2.getKeywordIndex() - 1;
        Unit<?> unit = this.parseUnitID(element2);
        element2.close(this.ignoredElements);
        if (unit != null) {
            return unit;
        }
        if (n >= 0 && n < BASE_UNITS.length) {
            if (n < CONVERSION_FACTORS.length) {
                d = MathTransformParser.completeUnitFactor(CONVERSION_FACTORS[n], d);
            }
            return BASE_UNITS[n].multiply(d);
        }
        try {
            return this.parseUnit(string);
        }
        catch (ParserException parserException) {
            throw new UnparsableObjectException(this.errorLocale, 150, new Object[]{string}, element2.offset).initCause(parserException);
        }
    }

    private static double completeUnitFactor(double[] dArray, double d) {
        int n = Arrays.binarySearch(dArray, d);
        if (n < 0) {
            double d2;
            n = Math.max(~n, 1);
            double d3 = dArray[n - 1];
            if (n < dArray.length && (d2 = dArray[n]) - d < d - d3) {
                d3 = d2;
            }
            if (DecimalFunctions.equalsIgnoreMissingFractionDigits((double)d3, (double)d)) {
                return d3;
            }
        }
        return d;
    }

    static double completeUnitFactor(Unit<?> unit, double d) {
        int n = CONVERSION_FACTORS.length;
        while (--n >= 0) {
            if (BASE_UNITS[n] != unit) continue;
            return MathTransformParser.completeUnitFactor(CONVERSION_FACTORS[n], d);
        }
        return d;
    }

    final void parseParameters(Element element, ParameterValueGroup parameterValueGroup, Unit<?> unit, Unit<Angle> unit2) throws ParseException {
        Unit unit3 = unit != null ? unit.getSystemUnit() : null;
        Element element2 = element;
        try {
            while ((element2 = element.pullElement(1, "Parameter")) != null) {
                String string = element2.pullString("name");
                Object object = this.parseUnit(element2);
                element2.pullElement(1, ID_KEYWORDS);
                ParameterValue parameterValue = parameterValueGroup.parameter(string);
                ParameterDescriptor parameterDescriptor = parameterValue.getDescriptor();
                Class clazz = parameterDescriptor.getValueClass();
                boolean bl = Number.class.isAssignableFrom(clazz);
                if (bl && object == null && (object = parameterDescriptor.getUnit()) != null) {
                    Unit unit4 = object.getSystemUnit();
                    if (unit4.equals(unit3)) {
                        object = unit;
                    } else if (unit4.equals(Units.RADIAN)) {
                        object = unit2;
                    }
                }
                if (object != null) {
                    parameterValue.setValue(element2.pullDouble("doubleValue"), (Unit)object);
                } else if (bl) {
                    if (Numbers.isInteger((Class)clazz)) {
                        parameterValue.setValue(element2.pullInteger("intValue"));
                    } else {
                        parameterValue.setValue(element2.pullDouble("doubleValue"));
                    }
                } else if (clazz == Boolean.class) {
                    parameterValue.setValue(element2.pullBoolean("booleanValue"));
                } else {
                    parameterValue.setValue((Object)element2.pullString("stringValue"));
                }
                element2.close(this.ignoredElements);
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            throw new UnparsableObjectException(this.errorLocale, 140, new String[]{parameterNotFoundException.getParameterName()}, element2.offset).initCause(parameterNotFoundException);
        }
        catch (InvalidParameterValueException invalidParameterValueException) {
            throw (ParseException)new ParseException(invalidParameterValueException.getLocalizedMessage(), element2.offset).initCause(invalidParameterValueException);
        }
    }

    private MathTransform parseParamMT(Element element) throws ParseException {
        MathTransform mathTransform;
        ParameterValueGroup parameterValueGroup;
        Element element2 = element.pullElement(0, "Param_MT");
        if (element2 == null) {
            return null;
        }
        this.classification = element2.pullString("classification");
        MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
        try {
            parameterValueGroup = mathTransformFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element2.parseFailed((Exception)((Object)noSuchIdentifierException));
        }
        this.parseParameters(element2, parameterValueGroup, null, null);
        element2.close(this.ignoredElements);
        try {
            mathTransform = mathTransformFactory.createParameterizedTransform(parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException));
        }
        this.lastMethod = mathTransformFactory.getLastMethodUsed();
        return mathTransform;
    }

    private MathTransform parseInverseMT(Element element) throws ParseException {
        Element element2 = element.pullElement(0, "Inverse_MT");
        if (element2 == null) {
            return null;
        }
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed((Exception)((Object)noninvertibleTransformException));
        }
        element2.close(this.ignoredElements);
        return mathTransform;
    }

    private MathTransform parsePassThroughMT(Element element) throws ParseException {
        Element element2 = element.pullElement(0, "PassThrough_MT");
        if (element2 == null) {
            return null;
        }
        int n = element.pullInteger("firstAffectedCoordinate");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
        element2.close(this.ignoredElements);
        try {
            return mathTransformFactory.createPassThroughTransform(n, mathTransform, 0);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed((Exception)((Object)factoryException));
        }
    }

    private MathTransform parseConcatMT(Element element) throws ParseException {
        MathTransform mathTransform;
        Element element2 = element.pullElement(0, "Concat_MT");
        if (element2 == null) {
            return null;
        }
        MathTransform mathTransform2 = this.parseMathTransform(element2, true);
        MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
        while ((mathTransform = this.parseMathTransform(element2, false)) != null) {
            try {
                mathTransform2 = mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransform);
            }
            catch (FactoryException factoryException) {
                throw element2.parseFailed((Exception)((Object)factoryException));
            }
        }
        element2.close(this.ignoredElements);
        return mathTransform2;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            MathTransformFactory mathTransformFactory = this.factories.getMathTransformFactory();
            this.lastMethod = CoordinateOperations.getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), this.classification);
        }
        return this.lastMethod;
    }
}

