/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.service.GettingStartedService;

@Path(value="getting-started")
@RolesAllowed(value={"users"})
@Api(value="/getting-started", description="Check getting Started steps for currently authenticated user")
public class GettingStartedRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GettingStartedRestService.class);
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private static final Date LAST_MODIFIED = new Date(System.currentTimeMillis());
    private static final Date EXPIRES_DATE = new Date(System.currentTimeMillis() + 1471228928L);
    private GettingStartedService gettingStartedService;

    public GettingStartedRestService(GettingStartedService gettingStartedService) {
        this.gettingStartedService = gettingStartedService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Collect Getting Started Steps", httpMethod="GET", response=Response.class, produces="application/json", notes="Return getting started steps in json format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getGettingStartedSteps() {
        ConversationState current = ConversationState.getCurrent();
        try {
            List gettinStartedSteps = this.gettingStartedService.getUserSteps(current.getIdentity().getUserId());
            if (gettinStartedSteps.isEmpty()) {
                Response.ResponseBuilder builder = Response.ok((Object)gettinStartedSteps, (String)"application/json");
                builder.lastModified(LAST_MODIFIED);
                builder.expires(EXPIRES_DATE);
                builder.cacheControl(CACHE_CONTROL);
                return builder.build();
            }
            return Response.ok((Object)gettinStartedSteps).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Unknown error occurred while getting user steps", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @ApiOperation(value="Delete Getting Started Application display for current user", httpMethod="DELETE", response=Response.class, notes="Doesn't return a response content")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=204, message="Internal server error")})
    public Response hideGettingStartedApplication() {
        ConversationState current = ConversationState.getCurrent();
        try {
            this.gettingStartedService.hideGettingStartedApplication(current.getIdentity().getUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Unknown error occurred while deleting Getting Started application for current user", (Throwable)e);
            return Response.serverError().build();
        }
    }

    static {
        CACHE_CONTROL.setMaxAge(31536000);
    }
}

