/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import java.util.HashMap;
import java.util.Map;
import org.gatein.common.text.AbstractCharEncoder;
import org.gatein.common.text.CharWriter;
import org.gatein.common.text.EncodingException;
import org.gatein.common.util.ParameterValidation;

public class EntityEncoder
extends AbstractCharEncoder {
    public static final EntityEncoder FULL = new EntityEncoder();
    public static final EntityEncoder BASIC = new BasicEntityTable();
    private Map<Character, String> charMap = new HashMap<Character, String>(255);
    private Map<String, Character> inverseCharMap = new HashMap<String, Character>(255);

    @Override
    public void encode(char c, CharWriter writer) throws EncodingException {
        ParameterValidation.throwIllegalArgExceptionIfNull(writer, "CharWriter");
        String s = this.lookup(c);
        if (s != null) {
            writer.append('&');
            writer.append(s);
            writer.append(';');
        } else {
            writer.append(c);
        }
    }

    @Override
    public void safeEncode(char[] chars, int off, int len, CharWriter writer) throws EncodingException {
        int previous = off;
        int to = off + len;
        for (int current = off; current < to; ++current) {
            String replacement = this.lookup(chars[current]);
            if (replacement == null) continue;
            writer.append(chars, previous, current - previous);
            writer.append('&').append(replacement).append(';');
            previous = current + 1;
        }
        writer.append(chars, previous, chars.length - previous);
    }

    protected EntityEncoder() {
        this.put(160, "nbsp");
        this.put(161, "iexcl");
        this.put(162, "cent");
        this.put(163, "pound");
        this.put(164, "curren");
        this.put(165, "yen");
        this.put(166, "brvbar");
        this.put(167, "sect");
        this.put(168, "uml");
        this.put(169, "copy");
        this.put(170, "ordf");
        this.put(171, "laquo");
        this.put(172, "not");
        this.put(173, "shy");
        this.put(174, "reg");
        this.put(175, "macr");
        this.put(176, "deg");
        this.put(177, "plusmn");
        this.put(178, "sup2");
        this.put(179, "sup3");
        this.put(180, "acute");
        this.put(181, "micro");
        this.put(182, "para");
        this.put(183, "middot");
        this.put(184, "cedil");
        this.put(185, "sup1");
        this.put(186, "ordm");
        this.put(187, "raquo");
        this.put(188, "frac14");
        this.put(189, "frac12");
        this.put(190, "frac34");
        this.put(191, "iquest");
        this.put(192, "Agrave");
        this.put(193, "Aacute");
        this.put(194, "Acirc");
        this.put(195, "Atilde");
        this.put(196, "Auml");
        this.put(197, "Aring");
        this.put(198, "AElig");
        this.put(199, "Ccedil");
        this.put(200, "Egrave");
        this.put(201, "Eacute");
        this.put(202, "Ecirc");
        this.put(203, "Euml");
        this.put(204, "Igrave");
        this.put(205, "Iacute");
        this.put(206, "Icirc");
        this.put(207, "Iuml");
        this.put(208, "ETH");
        this.put(209, "Ntilde");
        this.put(210, "Ograve");
        this.put(211, "Oacute");
        this.put(212, "Ocirc");
        this.put(213, "Otilde");
        this.put(214, "Ouml");
        this.put(215, "times");
        this.put(216, "Oslash");
        this.put(217, "Ugrave");
        this.put(218, "Uacute");
        this.put(219, "Ucirc");
        this.put(220, "Uuml");
        this.put(221, "Yacute");
        this.put(222, "THORN");
        this.put(223, "szlig");
        this.put(224, "agrave");
        this.put(225, "aacute");
        this.put(226, "acirc");
        this.put(227, "atilde");
        this.put(228, "auml");
        this.put(229, "aring");
        this.put(230, "aelig");
        this.put(231, "ccedil");
        this.put(232, "egrave");
        this.put(233, "eacute");
        this.put(234, "ecirc");
        this.put(235, "euml");
        this.put(236, "igrave");
        this.put(237, "iacute");
        this.put(238, "icirc");
        this.put(239, "iuml");
        this.put(240, "eth");
        this.put(241, "ntilde");
        this.put(242, "ograve");
        this.put(243, "oacute");
        this.put(244, "ocirc");
        this.put(245, "otilde");
        this.put(246, "ouml");
        this.put(247, "divide");
        this.put(248, "oslash");
        this.put(249, "ugrave");
        this.put(250, "uacute");
        this.put(251, "ucirc");
        this.put(252, "uuml");
        this.put(253, "yacute");
        this.put(254, "thorn");
        this.put(255, "yuml");
        this.put(402, "fnof");
        this.put(913, "Alpha");
        this.put(914, "Beta");
        this.put(915, "Gamma");
        this.put(916, "Delta");
        this.put(917, "Epsilon");
        this.put(918, "Zeta");
        this.put(919, "Eta");
        this.put(920, "Theta");
        this.put(921, "Iota");
        this.put(922, "Kappa");
        this.put(923, "Lambda");
        this.put(924, "Mu");
        this.put(925, "Nu");
        this.put(926, "Xi");
        this.put(927, "Omicron");
        this.put(928, "Pi");
        this.put(929, "Rho");
        this.put(931, "Sigma");
        this.put(932, "Tau");
        this.put(933, "Upsilon");
        this.put(934, "Phi");
        this.put(935, "Chi");
        this.put(936, "Psi");
        this.put(937, "Omega");
        this.put(945, "alpha");
        this.put(946, "beta");
        this.put(947, "gamma");
        this.put(948, "delta");
        this.put(949, "epsilon");
        this.put(950, "zeta");
        this.put(951, "eta");
        this.put(952, "theta");
        this.put(953, "iota");
        this.put(954, "kappa");
        this.put(955, "lambda");
        this.put(956, "mu");
        this.put(957, "nu");
        this.put(958, "xi");
        this.put(959, "omicron");
        this.put(960, "pi");
        this.put(961, "rho");
        this.put(962, "sigmaf");
        this.put(963, "sigma");
        this.put(964, "tau");
        this.put(965, "upsilon");
        this.put(966, "phi");
        this.put(967, "chi");
        this.put(968, "psi");
        this.put(969, "omega");
        this.put(977, "thetasym");
        this.put(978, "upsih");
        this.put(982, "piv");
        this.put(8226, "bull");
        this.put(8230, "hellip");
        this.put(8242, "prime");
        this.put(8243, "Prime");
        this.put(8254, "oline");
        this.put(8260, "frasl");
        this.put(8472, "weierp");
        this.put(8465, "image");
        this.put(8476, "real");
        this.put(8482, "trade");
        this.put(8501, "alefsym");
        this.put(8592, "larr");
        this.put(8593, "uarr");
        this.put(8594, "rarr");
        this.put(8595, "darr");
        this.put(8596, "harr");
        this.put(8629, "crarr");
        this.put(8656, "lArr");
        this.put(8657, "uArr");
        this.put(8658, "rArr");
        this.put(8659, "dArr");
        this.put(8660, "hArr");
        this.put(8704, "forall");
        this.put(8706, "part");
        this.put(8707, "exist");
        this.put(8709, "empty");
        this.put(8711, "nabla");
        this.put(8712, "isin");
        this.put(8713, "notin");
        this.put(8715, "ni");
        this.put(8719, "prod");
        this.put(8721, "sum");
        this.put(8722, "minus");
        this.put(8727, "lowast");
        this.put(8730, "radic");
        this.put(8733, "prop");
        this.put(8734, "infin");
        this.put(8736, "ang");
        this.put(8743, "and");
        this.put(8744, "or");
        this.put(8745, "cap");
        this.put(8746, "cup");
        this.put(8747, "int");
        this.put(8756, "there4");
        this.put(8764, "sim");
        this.put(8773, "cong");
        this.put(8776, "asymp");
        this.put(8800, "ne");
        this.put(8801, "equiv");
        this.put(8804, "le");
        this.put(8805, "ge");
        this.put(8834, "sub");
        this.put(8835, "sup");
        this.put(8836, "nsub");
        this.put(8838, "sube");
        this.put(8839, "supe");
        this.put(8853, "oplus");
        this.put(8855, "otimes");
        this.put(8869, "perp");
        this.put(8901, "sdot");
        this.put(8968, "lceil");
        this.put(8969, "rceil");
        this.put(8970, "lfloor");
        this.put(8971, "rfloor");
        this.put(9001, "lang");
        this.put(9002, "rang");
        this.put(9674, "loz");
        this.put(9824, "spades");
        this.put(9827, "clubs");
        this.put(9829, "hearts");
        this.put(9830, "diams");
        this.put(34, "quot");
        this.put(38, "amp");
        this.put(60, "lt");
        this.put(62, "gt");
        this.put(338, "OElig");
        this.put(339, "oelig");
        this.put(352, "Scaron");
        this.put(353, "scaron");
        this.put(376, "Yuml");
        this.put(710, "circ");
        this.put(732, "tilde");
        this.put(8194, "ensp");
        this.put(8195, "emsp");
        this.put(8201, "thinsp");
        this.put(8204, "zwnj");
        this.put(8205, "zwj");
        this.put(8206, "lrm");
        this.put(8207, "rlm");
        this.put(8211, "ndash");
        this.put(8212, "mdash");
        this.put(8216, "lsquo");
        this.put(8217, "rsquo");
        this.put(8218, "sbquo");
        this.put(8220, "ldquo");
        this.put(8221, "rdquo");
        this.put(8222, "bdquo");
        this.put(8224, "dagger");
        this.put(8225, "Dagger");
        this.put(8240, "permil");
        this.put(8249, "lsaquo");
        this.put(8250, "rsaquo");
        this.put(8364, "euro");
    }

    protected final void put(int c, String entity) {
        this.charMap.put(Character.valueOf((char)c), entity);
        this.inverseCharMap.put(entity, Character.valueOf((char)c));
    }

    protected final void remove(int c) {
        this.inverseCharMap.remove(this.charMap.get(Character.valueOf((char)c)));
        this.charMap.remove(Character.valueOf((char)c));
    }

    public final String lookup(char c) {
        return this.charMap.get(Character.valueOf(c));
    }

    public final int reverse(String s) {
        Character c = this.inverseCharMap.get(s);
        return c == null ? -1 : (int)c.charValue();
    }

    private static class BasicEntityTable
    extends EntityEncoder {
        public BasicEntityTable() {
            this.remove(60);
            this.remove(62);
            this.remove(34);
            this.remove(38);
        }
    }
}

