/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/perkstore/api/settings")
@Api(value="/perkstore/api/settings", description="Manages perk store application settings")
@RolesAllowed(value={"users"})
public class PerkStoreSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreSettingsREST.class);
    private PerkStoreService perkStoreService;

    public PerkStoreSettingsREST(PerkStoreService perkStoreService) {
        this.perkStoreService = perkStoreService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves perk store settings with user settings", httpMethod="GET", response=Response.class, produces="application/json", notes="returns global having user settings object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSettings() {
        String currentUserId = Utils.getCurrentUserId();
        try {
            return Response.ok((Object)this.perkStoreService.getGlobalSettings(currentUserId)).build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Retrieving global settings", currentUserId, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving global settings", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @Path(value="save")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Saves perk store global settings", httpMethod="POST", response=Response.class, produces="application/json", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveSettings(@ApiParam(value="Global settings to save", required=true) GlobalSettings settings) throws Exception {
        if (settings == null) {
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        if (!this.perkStoreService.isPerkStoreManager(currentUserId)) {
            return Response.status((int)403).build();
        }
        try {
            this.perkStoreService.saveGlobalSettings(settings, currentUserId);
            return Response.noContent().build();
        }
        catch (PerkStoreException e) {
            return Utils.computeErrorResponse(LOG, e, "Saving global settings", currentUserId, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving global settings", (Throwable)e);
            return Response.status((int)500).build();
        }
    }
}

