/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gatein.management.api.FilteredAddress;
import org.gatein.management.api.PathAddressIterator;
import org.gatein.management.api.PathTemplateFilter;
import org.gatein.management.api.PathTemplateResolver;

public class PathAddress
implements Iterable<String> {
    public static final PathAddress EMPTY_ADDRESS = new PathAddress(Collections.<String>emptyList());
    List<String> pathList;
    private List<PathTemplateResolver> resolvers;

    public static PathAddress empty() {
        return EMPTY_ADDRESS;
    }

    public static PathAddress pathAddress(String ... paths) {
        if (paths == null || paths.length == 0) {
            return PathAddress.empty();
        }
        PathAddress address = PathAddress.empty();
        for (String path : paths) {
            address = address.append(path);
        }
        return address;
    }

    public static PathAddress pathAddress(String addressPath) {
        if (addressPath == null || addressPath.length() == 0) {
            return PathAddress.empty();
        }
        if (addressPath.charAt(0) == '/') {
            addressPath = addressPath.substring(1, addressPath.length());
        }
        return new PathAddress(PathAddress.split(addressPath, "/"));
    }

    PathAddress(List<String> pathList) {
        this(pathList, new ArrayList<PathTemplateResolver>());
    }

    PathAddress(List<String> pathList, List<PathTemplateResolver> resolvers) {
        this.pathList = pathList;
        this.resolvers = resolvers;
    }

    public PathAddress append(String path) {
        return this.append(PathAddress.pathAddress(path));
    }

    public PathAddress append(PathAddress address) {
        ArrayList<String> list = new ArrayList<String>(this.pathList.size() + address.pathList.size());
        list.addAll(this.pathList);
        list.addAll(address.pathList);
        return new PathAddress(list, new ArrayList<PathTemplateResolver>(this.resolvers));
    }

    public PathAddress subAddress(int start) {
        return new PathAddress(this.pathList.subList(start, this.pathList.size()));
    }

    public PathAddress subAddress(int start, int end) {
        return new PathAddress(this.pathList.subList(start, end));
    }

    public String getLastElement() {
        return this.pathList.size() == 0 ? null : this.pathList.get(this.pathList.size() - 1);
    }

    public String get(int index) {
        return this.pathList.get(index);
    }

    public String resolvePathTemplate(String templateName) {
        for (PathTemplateResolver resolver : this.resolvers) {
            String resolved = resolver.resolve(templateName);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public void addPathTemplateResolver(PathTemplateResolver resolver) {
        this.resolvers.add(0, resolver);
    }

    public List<PathTemplateResolver> getPathTemplateResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    public boolean accepts(PathTemplateFilter filter) {
        FilteredAddress filtered = filter.filter(this);
        if (filtered != null && filtered.isFiltered()) {
            return filtered.matches();
        }
        return true;
    }

    public PathAddressIterator iterator() {
        return new PathAddressIterator(this);
    }

    public int size() {
        return this.pathList.size();
    }

    public PathAddress copy() {
        return new PathAddress(new ArrayList<String>(this.pathList), new ArrayList<PathTemplateResolver>(this.resolvers));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathAddress that = (PathAddress)o;
        return this.pathList.equals(that.pathList);
    }

    public int hashCode() {
        return this.pathList.hashCode();
    }

    public String toString() {
        PathAddressIterator iterator = this.iterator();
        StringBuilder sb = new StringBuilder("/");
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    static List<String> split(String string, String regex) {
        String[] split = string.split(regex);
        ArrayList<String> trimmed = new ArrayList<String>(split.length);
        for (String s : split) {
            if (s == null || s.equals("")) continue;
            trimmed.add(s.trim());
        }
        return trimmed;
    }
}

