/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import javax.security.auth.login.LoginException;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.jaas.AbstractLoginModule;

public class CustomMembershipLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(CustomMembershipLoginModule.class);
    private static final String OPTION_MEMBERSHIP_TYPE = "membershipType";
    private static final String OPTION_GROUP_ID = "groupId";
    private String membershipType;
    private String groupId;
    private MembershipEntry requestedMembershipEntry;

    protected void afterInitialize() {
        this.membershipType = this.options.get(OPTION_MEMBERSHIP_TYPE) != null ? (String)this.options.get(OPTION_MEMBERSHIP_TYPE) : "member";
        this.groupId = this.options.get(OPTION_GROUP_ID) != null ? (String)this.options.get(OPTION_GROUP_ID) : "/platform/users";
        this.requestedMembershipEntry = new MembershipEntry(this.groupId);
    }

    public boolean login() throws LoginException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"login invoked!");
        }
        try {
            Identity identity = null;
            if (this.sharedState.containsKey("exo.security.identity")) {
                identity = (Identity)this.sharedState.get("exo.security.identity");
            }
            if (identity == null) {
                log.warn((Object)"Identity not found in shared state under exo.security.identity. This login module will be ignored");
                return false;
            }
            if (identity.getMemberships().contains(this.requestedMembershipEntry)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Requested membership entry " + this.requestedMembershipEntry + " already presented for user " + identity.getUserId()));
                }
                return true;
            }
            log.info((Object)("User " + identity.getUserId() + " will be added to group " + this.groupId + " as " + this.membershipType + "."));
            this.addUserToPlatformUsers(identity.getUserId());
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            identity = authenticator.createIdentity(identity.getUserId());
            this.sharedState.put("exo.security.identity", identity);
            return true;
        }
        catch (Exception e) {
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserToPlatformUsers(String userId) throws Exception {
        OrganizationService orgService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        try {
            this.begin(orgService);
            User user = orgService.getUserHandler().findUserByName(userId);
            MembershipType memberType = orgService.getMembershipTypeHandler().findMembershipType(this.membershipType);
            Group platformUsersGroup = orgService.getGroupHandler().findGroupById(this.groupId);
            orgService.getMembershipHandler().linkMembership(user, platformUsersGroup, memberType, true);
        }
        catch (Exception e) {
            log.error((Object)("Failed to add user " + userId + " to group " + this.groupId + "."), (Throwable)e);
        }
        finally {
            this.end(orgService);
        }
    }

    private void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    private void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

