/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.access;

import org.exoplatform.services.security.MembershipEntry;

public class AccessControlEntry {
    private final String identity;
    private final String permission;
    private volatile MembershipEntry membership;
    public static final String DELIMITER = " ";
    private Integer hashcode = null;
    private String asString = null;

    public AccessControlEntry(String identity, String permission) {
        this.identity = identity;
        this.permission = permission;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getPermission() {
        return this.permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipEntry getMembershipEntry() {
        if (this.membership == null) {
            AccessControlEntry accessControlEntry = this;
            synchronized (accessControlEntry) {
                if (this.membership == null) {
                    this.membership = MembershipEntry.parse((String)this.getIdentity());
                }
            }
        }
        return this.membership;
    }

    public String getAsString() {
        if (this.asString == null) {
            this.asString = this.identity + DELIMITER + this.permission;
        }
        return this.asString;
    }

    public int hashCode() {
        if (this.hashcode == null) {
            this.hashcode = this.getAsString().hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntry) {
            AccessControlEntry another = (AccessControlEntry)obj;
            return this.getAsString().equals(another.getAsString());
        }
        return false;
    }

    public String toString() {
        return super.toString() + " (" + this.getAsString() + ")";
    }

    public static AccessControlEntry parse(String pstring) {
        if (pstring == null) {
            throw new IllegalArgumentException("The string representation of an AccessControlEntry cannot be null");
        }
        int index = pstring.lastIndexOf(DELIMITER);
        if (index == -1) {
            throw new IllegalArgumentException("The string representation of an AccessControlEntry must contain the delimiter ' '");
        }
        String identity = pstring.substring(0, index);
        String permission = pstring.substring(index + 1);
        return new AccessControlEntry(identity, permission);
    }
}

