/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import java.io.UnsupportedEncodingException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Identifier {
    private final String string;
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.datamodel.Identifier");

    public Identifier(String stringValue) {
        this.string = stringValue;
        this.checkValue(false);
    }

    public Identifier(String stringValue, boolean onlyCheck) {
        this.string = stringValue;
        this.checkValue(onlyCheck);
    }

    public Identifier(byte[] value) {
        try {
            this.string = new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Cannot read the value", e);
        }
        this.checkValue(true);
    }

    private void checkValue(boolean onlyCheck) throws IllegalArgumentException {
        if (this.string == null || this.string.isEmpty()) {
            if (onlyCheck) {
                LOG.warn((Object)"An identifier cannot be empty, please check and repair the jcr data");
            } else {
                throw new IllegalArgumentException("An identifier cannot be empty");
            }
        }
    }

    public String getString() {
        return this.string;
    }

    public boolean equals(Object another) {
        if (another instanceof Identifier) {
            return this.string.equals(((Identifier)another).string);
        }
        return false;
    }
}

