/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StringPersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

public abstract class StringValueData
extends AbstractValueData {
    protected String value;

    protected StringValueData(int orderNumber, String value) {
        super(orderNumber);
        this.value = value;
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof StringValueData) {
            return ((StringValueData)another).value.equals(this.value);
        }
        return false;
    }

    @Override
    protected byte[] spoolInternalValue() {
        try {
            return this.value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public String toString() {
        return this.value;
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new StringPersistedValueData(orderNumber, this.value);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    @Override
    protected Long getLong() {
        return Long.valueOf(this.value);
    }

    @Override
    protected Boolean getBoolean() {
        return Boolean.valueOf(this.value);
    }

    @Override
    protected Double getDouble() {
        return Double.valueOf(this.value);
    }

    @Override
    protected String getString() {
        return this.value;
    }

    @Override
    protected Calendar getDate() throws ValueFormatException {
        return JCRDateFormat.parse(this.value);
    }

    @Override
    protected InternalQName getName() throws IllegalNameException {
        return InternalQName.parse(this.value);
    }

    @Override
    protected QPath getPath() throws IllegalPathException {
        return QPath.parse(this.value);
    }

    @Override
    protected String getReference() {
        return this.value;
    }

    @Override
    protected AccessControlEntry getPermission() {
        return AccessControlEntry.parse(this.value);
    }
}

