/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.init;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

public class MSSQLDBInitializer
extends StorageDBInitializer {
    public MSSQLDBInitializer(Connection connection, JDBCDataContainerConfig containerConfig) throws IOException {
        super(connection, containerConfig);
    }

    @Override
    protected boolean isProcedureExists(final Connection conn, final String procedureName) throws SQLException {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return MSSQLDBInitializer.this.procedureExists(procedureName, conn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean procedureExists(String procedureName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String query = "select COUNT(*) from sys.procedures where name= '" + procedureName + "'";
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            bl = trs.next() && trs.getInt(1) >= 1;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the procedure " + procedureName), (Throwable)e);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                JDBCUtils.freeResources(trs, (Statement)stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources((ResultSet)trs, (Statement)stmt, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postInit(Connection connection) throws SQLException {
        super.postInit(connection);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (this.containerConfig.useSequenceForOrderNumber) {
                String select = "select * from JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ  where name='LAST_N_ORDER_NUM'";
                stmt = connection.createStatement();
                rs = stmt.executeQuery(select);
                if (!rs.next()) {
                    String insert = "INSERT INTO JCR_" + DBInitializerHelper.getItemTableSuffix(this.containerConfig) + "_SEQ  (name, nextVal) VALUES ('LAST_N_ORDER_NUM'," + this.getStartValue(connection) + ")";
                    stmt.executeUpdate(insert);
                }
            }
        }
        finally {
            JDBCUtils.freeResources(rs, stmt, null);
        }
    }
}

