/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.job;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class BoostAdminTransactionJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(BoostAdminTransactionJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private WalletTokenAdminService walletTokenAdminService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.getWalletTokenAdminService().boostAdminTransactions();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while Boosting transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }
}

