/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;

public class UnifiedSearchOrganizationProfileListener
extends UserProfileEventListener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchOrganizationProfileListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchOrganizationProfileListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void preSave(UserProfile user, boolean isNew) throws Exception {
    }

    public void postSave(UserProfile user, boolean isNew) throws Exception {
        if (this.indexingService != null) {
            HashMap<String, UserProfile> content = new HashMap<String, UserProfile>();
            content.put("profile", user);
            if (isNew) {
                SearchEntry searchEntry = new SearchEntry("social", "profile", user.getUserName(), content);
                this.indexingService.add(searchEntry);
            } else {
                SearchEntryId searchEntryId = new SearchEntryId("social", "profile", user.getUserName());
                this.indexingService.update(searchEntryId, content);
            }
        }
    }

    public void preDelete(UserProfile user) throws Exception {
    }

    public void postDelete(UserProfile user) throws Exception {
        if (this.indexingService != null) {
            SearchEntryId searchEntryId = new SearchEntryId("social", "profile", user.getUserName());
            this.indexingService.delete(searchEntryId);
        }
    }
}

