/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class TrailerValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfDoc = ctx.getDocument();
        COSDictionary linearizedDict = this.getLinearizedDictionary(pdfDoc);
        if (linearizedDict != null && ctx.getXrefTrailerResolver().getTrailerCount() == 2 && ctx.getFileLen() == linearizedDict.getLong(COSName.L)) {
            this.checkLinearizedDictionnary(ctx, linearizedDict);
            float pdfVersion = pdfDoc.getVersion();
            if (pdfVersion <= 1.4f) {
                this.checkTrailersForLinearizedPDF14(ctx);
            } else {
                this.checkTrailersForLinearizedPDF15(ctx);
            }
        } else {
            this.checkMainTrailer(ctx, pdfDoc.getDocument().getTrailer());
        }
    }

    protected void checkTrailersForLinearizedPDF14(PreflightContext ctx) {
        COSDictionary first = ctx.getXrefTrailerResolver().getFirstTrailer();
        if (first == null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4", "There are no trailer in the PDF file"));
        } else {
            COSDictionary last = ctx.getXrefTrailerResolver().getLastTrailer();
            COSDocument cosDoc = new COSDocument();
            this.checkMainTrailer(ctx, first);
            if (!this.compareIds(first, last, cosDoc)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.6", "ID is different in the first and the last trailer"));
            }
            COSUtils.closeDocumentQuietly(cosDoc);
        }
    }

    protected void checkTrailersForLinearizedPDF15(PreflightContext ctx) {
        PreflightDocument pdfDoc = ctx.getDocument();
        try {
            COSDocument cosDocument = pdfDoc.getDocument();
            List xrefs = cosDocument.getObjectsByType(COSName.XREF);
            if (xrefs.isEmpty()) {
                this.checkTrailersForLinearizedPDF14(ctx);
            } else {
                long min = Long.MAX_VALUE;
                long max = Long.MIN_VALUE;
                COSDictionary firstTrailer = null;
                COSDictionary lastTrailer = null;
                for (COSObject co : xrefs) {
                    long offset = (Long)cosDocument.getXrefTable().get(new COSObjectKey(co));
                    if (offset < min) {
                        min = offset;
                        firstTrailer = (COSDictionary)co.getObject();
                    }
                    if (offset <= max) continue;
                    max = offset;
                    lastTrailer = (COSDictionary)co.getObject();
                }
                this.checkMainTrailer(ctx, firstTrailer);
                if (!this.compareIds(firstTrailer, lastTrailer, cosDocument)) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.6", "ID is different in the first and the last trailer"));
                }
            }
        }
        catch (IOException e) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4", "Unable to check PDF Trailers: " + e.getMessage(), e));
        }
    }

    protected boolean compareIds(COSDictionary first, COSDictionary last, COSDocument cosDocument) {
        COSBase idFirst = first.getItem(COSName.getPDFName((String)"ID"));
        COSBase idLast = last.getItem(COSName.getPDFName((String)"ID"));
        if (idFirst != null && idLast != null) {
            COSArray af = COSUtils.getAsArray(idFirst, cosDocument);
            COSArray al = COSUtils.getAsArray(idLast, cosDocument);
            if (af == null || al == null) {
                return false;
            }
            boolean isEqual = true;
            for (Object of : af.toList()) {
                boolean oneIsEquals = false;
                for (Object ol : al.toList()) {
                    if (oneIsEquals) break;
                    oneIsEquals = ((COSString)ol).getString().equals(((COSString)of).getString());
                }
                if (isEqual = isEqual && oneIsEquals) continue;
                break;
            }
            return isEqual;
        }
        return true;
    }

    protected void checkMainTrailer(PreflightContext ctx, COSDictionary trailer) {
        COSBase trailerInfo;
        COSBase trailerPrev;
        boolean id = false;
        boolean root = false;
        boolean size = false;
        boolean prev = false;
        boolean info = false;
        boolean encrypt = false;
        for (Object key : trailer.keySet()) {
            if (!(key instanceof COSName)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.0.7", "Invalid key in The trailer dictionary"));
                return;
            }
            String cosName = ((COSName)key).getName();
            if (cosName.equals("Encrypt")) {
                encrypt = true;
            }
            if (cosName.equals("Size")) {
                size = true;
            }
            if (cosName.equals("Prev")) {
                prev = true;
            }
            if (cosName.equals("Root")) {
                root = true;
            }
            if (cosName.equals("Info")) {
                info = true;
            }
            if (!cosName.equals("ID")) continue;
            id = true;
        }
        COSDocument cosDocument = ctx.getDocument().getDocument();
        if (!id) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.1", "The trailer dictionary doesn't contain ID"));
        } else {
            COSBase trailerId = trailer.getItem("ID");
            if (!COSUtils.isArray(trailerId, cosDocument)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains an id but it isn't an array"));
            }
        }
        if (encrypt) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.2", "The trailer dictionary contains Encrypt"));
        }
        if (!size) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.4", "The trailer dictionary doesn't contain Size"));
        } else {
            COSBase trailerSize = trailer.getItem("Size");
            if (!COSUtils.isInteger(trailerSize, cosDocument)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a size but it isn't an integer"));
            }
        }
        if (!root) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.5", "The trailer dictionary doesn't contain Root"));
        } else {
            COSBase trailerRoot = trailer.getItem("Root");
            if (!COSUtils.isDictionary(trailerRoot, cosDocument)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a root but it isn't a dictionary"));
            }
        }
        if (prev && !COSUtils.isInteger(trailerPrev = trailer.getItem("Prev"), cosDocument)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains a prev but it isn't an integer"));
        }
        if (info && !COSUtils.isDictionary(trailerInfo = trailer.getItem("Info"), cosDocument)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.3", "The trailer dictionary contains an info but it isn't a dictionary"));
        }
    }

    protected COSDictionary getLinearizedDictionary(PDDocument document) {
        COSDocument cDoc = document.getDocument();
        List lObj = cDoc.getObjects();
        for (Object object : lObj) {
            COSBase curObj = ((COSObject)object).getObject();
            if (!(curObj instanceof COSDictionary) || !((COSDictionary)curObj).keySet().contains(COSName.getPDFName((String)"Linearized"))) continue;
            return (COSDictionary)curObj;
        }
        return null;
    }

    protected void checkLinearizedDictionnary(PreflightContext ctx, COSDictionary linearizedDict) {
        boolean l = false;
        boolean h = false;
        boolean o = false;
        boolean e = false;
        boolean n = false;
        boolean t = false;
        for (Object key : linearizedDict.keySet()) {
            if (!(key instanceof COSName)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("1.0.7", "Invalid key in The Linearized dictionary"));
                return;
            }
            String cosName = ((COSName)key).getName();
            if (cosName.equals("L")) {
                l = true;
            }
            if (cosName.equals("H")) {
                h = true;
            }
            if (cosName.equals("O")) {
                o = true;
            }
            if (cosName.equals("E")) {
                e = true;
            }
            if (cosName.equals("N")) {
                n = true;
            }
            if (!cosName.equals("T")) continue;
            t = true;
        }
        if (!(l && h && o && e && t && n)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.3", "Invalid key in The Linearized dictionary"));
        }
    }
}

