/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ExceptionMapper;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.DependencySupplier;
import org.exoplatform.services.rest.impl.ExceptionMapperComponentPlugin;
import org.exoplatform.services.rest.impl.InternalException;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestDispatcher;
import org.exoplatform.services.rest.impl.RequestFilterComponentPlugin;
import org.exoplatform.services.rest.impl.ResponseFilterComponentPlugin;
import org.exoplatform.services.rest.impl.UnhandledException;
import org.exoplatform.services.rest.impl.method.MethodInvokerFilterComponentPlugin;
import org.exoplatform.services.rest.impl.provider.EntityProviderComponentPlugin;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.picocontainer.Startable;

public final class RequestHandlerImpl
implements RequestHandler,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.RequestHandlerImpl");
    private static final Map<String, String> properties = new HashMap<String, String>();
    private final RequestDispatcher dispatcher;
    private final DependencySupplier dependencySupplier;

    public static final String getProperty(String name) {
        return properties.get(name);
    }

    public static final void setProperty(String name, String value) {
        if (value == null) {
            properties.remove(name);
        } else {
            properties.put(name, value);
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, DependencySupplier dependencySupplier, InitParams params) {
        this.dispatcher = dispatcher;
        this.dependencySupplier = dependencySupplier;
        if (params != null) {
            Iterator i = params.getValueParamIterator();
            while (i.hasNext()) {
                ValueParam vp = (ValueParam)i.next();
                properties.put(vp.getName(), vp.getValue());
            }
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, InitParams params) {
        this(dispatcher, new DependencySupplier(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws Exception {
        try {
            Object f;
            ProviderBinder defaultProviders = ProviderBinder.getInstance();
            ApplicationContextImpl context = new ApplicationContextImpl(request, response, defaultProviders, this.dependencySupplier);
            context.getProperties().putAll(properties);
            ApplicationContextImpl.setCurrent(context);
            for (ObjectFactory<FilterDescriptor> factory : defaultProviders.getRequestFilters(context.getPath())) {
                f = (RequestFilter)factory.getInstance(context);
                f.doFilter(request);
            }
            try {
                this.dispatcher.dispatch(request, response);
            }
            catch (WebApplicationException e) {
                Response errorResponse = e.getResponse();
                ExceptionMapper<WebApplicationException> excmap = context.getProviders().getExceptionMapper(WebApplicationException.class);
                int errorStatus = errorResponse.getStatus();
                if (errorStatus < 500) {
                    if (LOG.isDebugEnabled() && e.getCause() != null) {
                        LOG.warn((Object)"WebApplication exception occurs.", e.getCause());
                    }
                } else if (e.getCause() != null) {
                    LOG.warn((Object)"WebApplication exception occurs.", e.getCause());
                }
                if (errorResponse.getEntity() == null) {
                    if (excmap != null) {
                        errorResponse = excmap.toResponse((Throwable)e);
                    } else if (e.getMessage() != null) {
                        errorResponse = this.createErrorResponse(errorStatus, e.getMessage());
                    }
                }
                response.setResponse(errorResponse);
            }
            catch (InternalException e) {
                Throwable cause = e.getCause();
                Class<?> causeClazz = cause.getClass();
                ExceptionMapper<?> excmap = context.getProviders().getExceptionMapper(causeClazz);
                while (causeClazz != null && excmap == null) {
                    excmap = context.getProviders().getExceptionMapper(causeClazz);
                    if (excmap != null) continue;
                    causeClazz = causeClazz.getSuperclass();
                }
                if (excmap != null) {
                    response.setResponse(excmap.toResponse(e.getCause()));
                }
                LOG.error((Object)"Internal error occurs.", cause);
                throw new UnhandledException(e.getCause());
            }
            for (ObjectFactory<FilterDescriptor> factory : defaultProviders.getResponseFilters(context.getPath())) {
                f = (ResponseFilter)factory.getInstance(context);
                f.doFilter(response);
            }
            response.writeResponse();
        }
        finally {
            ApplicationContextImpl.setCurrent(null);
        }
    }

    private Response createErrorResponse(int status, String message) {
        Response.ResponseBuilder responseBuilder = Response.status((int)status);
        responseBuilder.entity((Object)message).type("text/plain");
        return responseBuilder.build();
    }

    public void start() {
        this.init();
    }

    public void stop() {
        File[] files;
        String tmpDirName = properties.get("ws.rs.tmpdir");
        File tmpDir = new File(tmpDirName);
        if (!PrivilegedFileHelper.exists((File)tmpDir)) {
            return;
        }
        for (File file : files = PrivilegedFileHelper.listFiles((File)tmpDir)) {
            if (!PrivilegedFileHelper.exists((File)file)) continue;
            PrivilegedFileHelper.delete((File)file);
        }
    }

    public void init() {
        File tmpDir;
        String tmpDirName = properties.get("ws.rs.tmpdir");
        if (tmpDirName == null) {
            tmpDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir") + File.separator + "ws_jaxrs");
            properties.put("ws.rs.tmpdir", tmpDir.getPath());
        } else {
            tmpDir = new File(tmpDirName);
        }
        if (!PrivilegedFileHelper.exists((File)tmpDir)) {
            PrivilegedFileHelper.mkdirs((File)tmpDir);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        block6: {
            ProviderBinder providers;
            block9: {
                block8: {
                    block7: {
                        block5: {
                            providers = ProviderBinder.getInstance();
                            if (!MethodInvokerFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block5;
                            for (Class<? extends MethodInvokerFilter> filter : ((MethodInvokerFilterComponentPlugin)plugin).getFilters()) {
                                providers.addMethodInvokerFilter(filter);
                            }
                            break block6;
                        }
                        if (!EntityProviderComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block7;
                        Set<Class<? extends EntityProvider>> eps = ((EntityProviderComponentPlugin)plugin).getEntityProviders();
                        for (Class<? extends EntityProvider> clazz : eps) {
                            providers.addMessageBodyReader(clazz);
                            providers.addMessageBodyWriter(clazz);
                        }
                        break block6;
                    }
                    if (!RequestFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block8;
                    Set<Class<? extends RequestFilter>> filters = ((RequestFilterComponentPlugin)plugin).getFilters();
                    for (Class<? extends RequestFilter> clazz : filters) {
                        providers.addRequestFilter(clazz);
                    }
                    break block6;
                }
                if (!ResponseFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block9;
                Set<Class<? extends ResponseFilter>> filters = ((ResponseFilterComponentPlugin)plugin).getFilters();
                for (Class<? extends ResponseFilter> clazz : filters) {
                    providers.addResponseFilter(clazz);
                }
                break block6;
            }
            if (!ExceptionMapperComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block6;
            Set<Class<ExceptionMapper<?>>> emaps = ((ExceptionMapperComponentPlugin)plugin).getExceptionMappers();
            for (Class<? extends ExceptionMapper<?>> clazz : emaps) {
                providers.addExceptionMapper(clazz);
            }
        }
    }

    static class ErrorStreaming
    implements StreamingOutput {
        private final Exception e;

        ErrorStreaming(Exception e) {
            this.e = e;
        }

        public void write(OutputStream output) {
            PrintWriter pw = new PrintWriter(output);
            this.e.printStackTrace(pw);
            pw.flush();
        }
    }
}

