/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.Reader;
import java.util.Map;
import org.exoplatform.portal.resource.CharSequenceReader;
import org.exoplatform.portal.resource.Codec;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class CompositeResourceResolver
implements ResourceResolver {
    private final Map<SkinKey, SkinConfig> skins;
    private final String portalContainerName;
    private final String prefix;
    private final Log log = ExoLogger.getLogger(CompositeResourceResolver.class);

    public CompositeResourceResolver(String portalContainerName, Map<SkinKey, SkinConfig> skins) {
        this.portalContainerName = portalContainerName;
        this.skins = skins;
        this.prefix = "/" + portalContainerName + "/resource/";
    }

    @Override
    public Resource resolve(String path) {
        if (path == null) {
            throw new NullPointerException("No null path is accepted");
        }
        if (path.startsWith(this.prefix) && path.endsWith(".css")) {
            final StringBuilder sb = new StringBuilder();
            String encoded = path.substring(this.prefix.length());
            String[] blah = encoded.split("/");
            int len = blah.length >> 1 << 1;
            for (int i = 0; i < len; i += 2) {
                String name = Codec.decode(blah[i]);
                String module = Codec.decode(blah[i + 1]);
                SkinKey key = new SkinKey(module, name);
                SkinConfig skin = this.skins.get(key);
                if (skin == null) continue;
                sb.append("@import url(").append(skin.getCSSPath()).append(");").append("\n");
            }
            return new Resource(path){

                @Override
                public Reader read() {
                    return new CharSequenceReader(sb);
                }
            };
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Could not resolve path value");
        }
        return null;
    }
}

