/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;

public class GroupIdentityProvider
extends IdentityProvider<Group> {
    private OrganizationService organizationService;
    public static final String NAME = "group";
    private static final Log LOG = ExoLogger.getExoLogger(GroupIdentityProvider.class);

    public GroupIdentityProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public String getName() {
        return NAME;
    }

    public Group findByRemoteId(String remoteId) {
        Group group;
        try {
            GroupHandler groupHandler = this.organizationService.getGroupHandler();
            group = groupHandler.findGroupById(remoteId);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find group " + remoteId));
            return null;
        }
        return group;
    }

    public Identity createIdentity(Group group) {
        Identity identity = new Identity(NAME, group.getId());
        return identity;
    }

    public void populateProfile(Profile profile, Group group) {
        profile.setProperty("firstName", (Object)group.getLabel());
        profile.setProperty("username", (Object)group.getGroupName());
    }
}

