/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.io;

import java.util.LinkedList;
import juzu.io.Chunk;
import juzu.io.Stream;

public final class SafeStream
implements Stream {
    private LinkedList<Exception> errors;
    private final Stream delegate;

    public SafeStream(Stream delegate) {
        this.delegate = delegate;
    }

    private void log(Exception error) {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
        this.errors.add(error);
    }

    @Override
    public void provide(Chunk chunk) {
        try {
            this.delegate.provide(chunk);
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    @Override
    public void close(Thread.UncaughtExceptionHandler errorHandler) {
        try {
            this.delegate.close(errorHandler);
        }
        catch (Exception e) {
            this.log(e);
        }
        if (errorHandler != null && this.errors != null) {
            for (Exception error : this.errors) {
                errorHandler.uncaughtException(null, error);
            }
        }
    }
}

