/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;

final class ConcatenatedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 4639375525939012394L;
    private final Vector first;
    private final Vector second;
    private final int limit;

    public ConcatenatedVector(Vector vector, Vector vector2) {
        this.first = vector;
        this.second = vector2;
        this.limit = vector.size();
    }

    @Override
    public Class<? extends Number> getElementType() {
        return Classes.findCommonClass(this.first.getElementType(), this.second.getElementType()).asSubclass(Number.class);
    }

    @Override
    public boolean isInteger() {
        return this.first.isInteger() && this.second.isInteger();
    }

    @Override
    public boolean isUnsigned() {
        return this.first.isUnsigned() && this.second.isUnsigned();
    }

    @Override
    public int size() {
        return this.limit + this.second.size();
    }

    @Override
    public boolean isNaN(int n) throws IndexOutOfBoundsException {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.isNaN(n);
    }

    @Override
    public double doubleValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.doubleValue(n);
    }

    @Override
    public float floatValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.floatValue(n);
    }

    @Override
    public long longValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.longValue(n);
    }

    @Override
    public int intValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.intValue(n);
    }

    @Override
    public short shortValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.shortValue(n);
    }

    @Override
    public byte byteValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.byteValue(n);
    }

    @Override
    public String stringValue(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.stringValue(n);
    }

    @Override
    public Number get(int n) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        return vector.get(n);
    }

    @Override
    public Number set(int n, Number number) {
        Vector vector;
        if (n < this.limit) {
            vector = this.first;
        } else {
            vector = this.second;
            n -= this.limit;
        }
        Number number2 = vector.set(n, number);
        ++this.modCount;
        return number2;
    }

    @Override
    public Number increment(double d) {
        Class<? extends Number> clazz;
        Number number;
        Number number2 = this.first.increment(d);
        if (number2 != null && (number = this.second.increment(d)) != null && (number2 = Numbers.cast(number2, clazz = Numbers.widestClass(number2.getClass(), number.getClass()))).equals(number = Numbers.cast(number, clazz))) {
            return number2;
        }
        return null;
    }

    @Override
    public NumberRange<?> range() {
        return this.first.range().unionAny(this.second.range());
    }

    @Override
    Vector createSubSampling(int n, int n2, int n3) {
        if (n >= this.limit) {
            return this.second.subSampling(n - this.limit, n2, n3);
        }
        if (n + n2 * n3 <= this.limit) {
            return this.first.subSampling(n, n2, n3);
        }
        return super.createSubSampling(n, n2, n3);
    }

    @Override
    Vector createConcatenate(Vector vector) {
        return this.first.concatenate(this.second.concatenate(vector));
    }

    @Override
    Vector createTransform(double d, double d2) {
        return this.first.transform(d, d2).concatenate(this.second.transform(d, d2));
    }
}

