/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.ipc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.web3j.protocol.ipc.IOFacade;

public class UnixDomainSocket
implements IOFacade {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    private final InputStreamReader reader;
    private final PrintWriter writer;
    private final UnixSocketChannel channel;

    public UnixDomainSocket(String ipcSocketPath) {
        this(ipcSocketPath, 1024);
    }

    public UnixDomainSocket(String ipcSocketPath, int bufferSize) {
        this.bufferSize = bufferSize;
        try {
            UnixSocketAddress address = new UnixSocketAddress(ipcSocketPath);
            this.channel = UnixSocketChannel.open((UnixSocketAddress)address);
            this.reader = new InputStreamReader(Channels.newInputStream((ReadableByteChannel)this.channel));
            this.writer = new PrintWriter(Channels.newOutputStream((WritableByteChannel)this.channel));
        }
        catch (IOException e) {
            throw new RuntimeException("Provided file socket cannot be opened: " + ipcSocketPath, e);
        }
    }

    UnixDomainSocket(InputStreamReader reader, PrintWriter writer, int bufferSize) {
        this.bufferSize = bufferSize;
        this.writer = writer;
        this.reader = reader;
        this.channel = null;
    }

    @Override
    public void write(String payload) throws IOException {
        this.writer.write(payload);
        this.writer.flush();
    }

    @Override
    public String read() throws IOException {
        CharBuffer response = CharBuffer.allocate(this.bufferSize);
        StringBuilder result = new StringBuilder();
        do {
            response.clear();
            this.reader.read(response);
            result.append(response.array(), response.arrayOffset(), response.position());
        } while (response.get(response.position() - 1) != '\n');
        return result.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
        if (null != this.channel) {
            this.channel.close();
        }
    }
}

