/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mobile;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.mobile.QRcodeUtil;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/mobile")
@Api(tags={"/mobile"}, value="/mobile")
public class MobileRestService
implements ResourceContainer {
    @GET
    @Path(value="/app/download")
    @ApiOperation(value="redirect the user to the appropriate link to download the mobile application", httpMethod="GET", response=String.class, notes="Use this method as an intermediate step when scanning the QR code to download the mobile application. The method will parse the user agent provided in the header and will redirect the user to either google play or the app store.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled. user-agent pertaining to an android or an ios device", response=String.class), @ApiResponse(code=400, message="the device that requested the service is not an android or an ios")})
    public Response redirectToStore(@ApiParam(value="the user-agent, ex: 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0'", required=true) @HeaderParam(value="user-agent") String userAgent) {
        if (QRcodeUtil.isIphone(userAgent)) {
            return Response.temporaryRedirect((URI)URI.create(QRcodeUtil.appleDownloadUrl)).build();
        }
        if (QRcodeUtil.isAndroid(userAgent)) {
            return Response.temporaryRedirect((URI)URI.create(QRcodeUtil.androidDownloadUrl)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"please use an iphone or an android to scan the qr code").build();
    }
}

