/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyXmlSerializer
extends XmlSerializer {
    private static final String DEFAULT_INDENTATION_STRING = "\t";
    private String indentString = "\t";
    private List<String> indents = new ArrayList<String>();

    public PrettyXmlSerializer(CleanerProperties props) {
        this(props, DEFAULT_INDENTATION_STRING);
    }

    public PrettyXmlSerializer(CleanerProperties props, String indentString) {
        super(props);
        this.indentString = indentString;
    }

    @Override
    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializePrettyXml(tagNode, writer, 0);
    }

    private synchronized String getIndent(int level) {
        int size = this.indents.size();
        if (size <= level) {
            String prevIndent = size == 0 ? null : this.indents.get(size - 1);
            for (int i = size; i <= level; ++i) {
                String currIndent = prevIndent == null ? "" : prevIndent + this.indentString;
                this.indents.add(currIndent);
                prevIndent = currIndent;
            }
        }
        return this.indents.get(level);
    }

    private String getIndentedText(String content, int level) {
        String indent = this.getIndent(level);
        StringBuilder result = new StringBuilder(content.length());
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if ("".equals(line)) continue;
            result.append(indent).append(line).append("\n");
        }
        return result.toString();
    }

    private String getSingleLineOfChildren(List<? extends BaseToken> children) {
        StringBuilder result = new StringBuilder();
        Iterator<? extends BaseToken> childrenIt = children.iterator();
        boolean isFirst = true;
        while (childrenIt.hasNext()) {
            BaseToken child = childrenIt.next();
            if (!(child instanceof ContentNode)) {
                return null;
            }
            String content = child.toString();
            if (isFirst) {
                content = this.ltrim(content);
            }
            if (!childrenIt.hasNext()) {
                content = this.rtrim(content);
            }
            if (content.indexOf("\n") >= 0 || content.indexOf("\r") >= 0) {
                return null;
            }
            result.append(content);
            isFirst = false;
        }
        return result.toString();
    }

    protected void serializePrettyXml(TagNode tagNode, Writer writer, int level) throws IOException {
        List<? extends BaseToken> tagChildren = tagNode.getAllChildren();
        boolean isHeadlessNode = Utils.isEmptyString(tagNode.getName());
        String indent = isHeadlessNode ? "" : this.getIndent(level);
        writer.write(indent);
        this.serializeOpenTag(tagNode, writer, true);
        if (!this.isMinimizedTagSyntax(tagNode)) {
            String singleLine = this.getSingleLineOfChildren(tagChildren);
            boolean dontEscape = this.dontEscape(tagNode);
            if (singleLine != null) {
                if (!this.dontEscape(tagNode)) {
                    writer.write(this.escapeXml(singleLine));
                } else {
                    writer.write(singleLine.replaceAll("]]>", "]]&gt;"));
                }
            } else {
                if (!isHeadlessNode) {
                    writer.write("\n");
                }
                for (BaseToken baseToken : tagChildren) {
                    if (baseToken instanceof TagNode) {
                        this.serializePrettyXml((TagNode)baseToken, writer, isHeadlessNode ? level : level + 1);
                        continue;
                    }
                    if (baseToken instanceof CData) {
                        this.serializeCData((CData)baseToken, tagNode, writer);
                        continue;
                    }
                    if (baseToken instanceof ContentNode) {
                        String content = dontEscape ? baseToken.toString().replaceAll("]]>", "]]&gt;") : this.escapeXml(baseToken.toString());
                        writer.write(this.getIndentedText(content, isHeadlessNode ? level : level + 1));
                        continue;
                    }
                    if (!(baseToken instanceof CommentNode)) continue;
                    CommentNode commentNode = (CommentNode)baseToken;
                    String content = commentNode.getCommentedContent();
                    writer.write(this.getIndentedText(content, isHeadlessNode ? level : level + 1));
                }
            }
            if (singleLine == null) {
                writer.write(indent);
            }
            this.serializeEndTag(tagNode, writer, true);
        }
    }

    private String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        return index >= len ? "" : s.substring(index);
    }

    private String rtrim(String s) {
        int len;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        return index <= 0 ? "" : s.substring(0, index);
    }
}

