/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.generic;

import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class GamificationGenericListener
extends Listener<Map<String, String>, String> {
    public static final String EVENT_NAME = "exo.gamification.generic.action";
    protected PortalContainer container;
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationGenericListener(PortalContainer container, RuleService ruleService, IdentityManager identityManager, GamificationService gamificationService) {
        this.container = container;
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Map<String, String>, String> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String ruleTitle = (String)((Map)event.getSource()).get("ruleTitle");
            String senderId = (String)((Map)event.getSource()).get("senderId");
            String senderType = (String)((Map)event.getSource()).get("senderType");
            String receiverId = (String)((Map)event.getSource()).get("receiverId");
            String obj = (String)((Map)event.getSource()).get("object");
            Identity senderIdentity = null;
            if (senderType != null) {
                String providerId = IdentityType.getType(senderType).getProviderId();
                senderIdentity = this.identityManager.getOrCreateIdentity(providerId, senderId);
            }
            if (senderIdentity == null && NumberUtils.isDigits((String)senderId)) {
                senderIdentity = this.identityManager.getIdentity(senderId);
            }
            if (senderIdentity == null) {
                senderIdentity = this.identityManager.getOrCreateIdentity("organization", senderId);
            }
            if (senderIdentity == null) {
                throw new IllegalStateException("Can't find identity with senderId = " + senderId);
            }
            Identity receiverIdentity = null;
            if (NumberUtils.isDigits((String)receiverId)) {
                receiverIdentity = this.identityManager.getIdentity(receiverId);
            }
            if (receiverIdentity == null) {
                receiverIdentity = this.identityManager.getOrCreateIdentity("organization", receiverId);
            }
            if (receiverIdentity == null) {
                throw new IllegalStateException("Can't find identity with receiverId = " + receiverId);
            }
            this.gamificationService.createHistory(ruleTitle, senderIdentity.getId(), receiverIdentity.getId(), obj);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

