/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage;

import java.util.Date;
import java.util.List;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.dto.configuration.Announcement;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.service.mapper.EntityMapper;
import org.exoplatform.addons.gamification.storage.RuleStorage;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.addons.gamification.utils.Utils;

public class AnnouncementStorage {
    private GamificationHistoryDAO announcementDAO;
    private RuleStorage challengeStorage;
    public static final long MILLIS_IN_A_DAY = 86400000L;

    public AnnouncementStorage(GamificationHistoryDAO announcementDAO, RuleStorage challengeStorage) {
        this.announcementDAO = announcementDAO;
        this.challengeStorage = challengeStorage;
    }

    public Announcement saveAnnouncement(Announcement announcement) {
        if (announcement == null) {
            throw new IllegalArgumentException("Announcement argument is null");
        }
        Challenge challenge = this.challengeStorage.getChallengeById(announcement.getChallengeId());
        RuleEntity challengeEntity = EntityMapper.toEntity(challenge);
        GamificationActionsHistory announcementEntity = EntityMapper.toEntity(announcement);
        Date nextToEndDate = new Date(challengeEntity.getEndDate().getTime() + 86400000L);
        if (!announcementEntity.getCreatedDate().before(nextToEndDate)) {
            throw new IllegalArgumentException("announcement is not allowed when challenge is ended ");
        }
        if (!announcementEntity.getCreatedDate().after(challengeEntity.getStartDate())) {
            throw new IllegalArgumentException("announcement is not allowed when challenge is not started ");
        }
        DomainEntity domainEntity = DomainMapper.domainDTOToDomain(Utils.getDomainByTitle(challenge.getProgram()));
        announcementEntity.setEarnerType(IdentityType.USER);
        announcementEntity.setActionTitle(challengeEntity.getTitle());
        announcementEntity.setActionScore(challengeEntity.getScore());
        announcementEntity.setGlobalScore(Utils.getUserGlobalScore(String.valueOf(announcement.getAssignee())));
        announcementEntity.setDomainEntity(domainEntity);
        announcementEntity.setDomain(domainEntity.getTitle());
        announcementEntity = announcementEntity.getId() == null ? (GamificationActionsHistory)this.announcementDAO.create(announcementEntity) : (GamificationActionsHistory)this.announcementDAO.update(announcementEntity);
        return EntityMapper.fromEntity(announcementEntity);
    }

    public Announcement getAnnouncementById(long announcementId) {
        GamificationActionsHistory announcementEntity = (GamificationActionsHistory)this.announcementDAO.find(Long.valueOf(announcementId));
        return EntityMapper.fromEntity(announcementEntity);
    }

    public List<Announcement> findAllAnnouncementByChallenge(Long challengeId, int offset, int limit) {
        List<GamificationActionsHistory> announcementEntities = this.announcementDAO.findAllAnnouncementByChallenge(challengeId, offset, limit);
        return EntityMapper.fromAnnouncementEntities(announcementEntities);
    }

    public Long countAnnouncementsByChallenge(Long challengeId) {
        return this.announcementDAO.countAnnouncementsByChallenge(challengeId);
    }
}

