/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;
import org.exoplatform.social.metadata.model.MetadataItem;

public class ActivityData
implements CacheData<ExoSocialActivity> {
    private static final long serialVersionUID = -7626120214861121711L;
    public static final ActivityData NULL = new ActivityData((ExoSocialActivity)new ExoSocialActivityImpl());
    private final String id;
    private final String title;
    private final String body;
    private final String[] likes;
    private final boolean isComment;
    private final boolean isHidden;
    private final boolean isLocked;
    private final Long postedTime;
    private final Long lastUpdated;
    private final Long cacheTime;
    private final String[] replyIds;
    private final String userId;
    private final String spaceId;
    private final String appId;
    private final String titleId;
    private final String bodyId;
    private final String type;
    private final Map templateParams;
    private final Map<String, Object> linkedProcessedEntities;
    private final String externalId;
    private final String url;
    private final String streamId;
    private final String streamOwner;
    private final String streamFaviconUrl;
    private final String streamSourceUrl;
    private final String streamTitle;
    private final String streamUrl;
    private final String[] mentioners;
    private final String[] commenters;
    private final ActivityStream.Type streamType;
    private final String posterId;
    private final String parentId;
    private final String parentCommentId;
    private final Set<ActivityShareAction> shareActions;
    private final List<ActivityFile> files;
    private final Map<String, List<MetadataItem>> metadatas;

    public ActivityData(ExoSocialActivity activity) {
        this.id = activity.getId();
        this.title = activity.getTitle();
        this.body = activity.getBody();
        this.likes = activity.getLikeIdentityIds();
        this.isComment = activity.isComment();
        this.isHidden = activity.isHidden();
        this.isLocked = activity.isLocked();
        this.postedTime = activity.getPostedTime();
        this.lastUpdated = activity.getUpdated().getTime();
        this.cacheTime = System.currentTimeMillis();
        this.replyIds = activity.getReplyToId();
        this.userId = activity.getUserId();
        this.spaceId = activity.getSpaceId();
        this.appId = activity.getAppId();
        this.titleId = activity.getTitleId();
        this.bodyId = activity.getBodyId();
        this.type = activity.getType();
        this.externalId = activity.getExternalId();
        this.url = activity.getUrl();
        this.streamId = activity.getStreamId();
        this.streamOwner = activity.getStreamOwner();
        this.streamFaviconUrl = activity.getStreamFaviconUrl();
        this.streamSourceUrl = activity.getStreamSourceUrl();
        this.streamTitle = activity.getStreamTitle();
        this.streamUrl = activity.getStreamUrl();
        this.mentioners = activity.getMentionedIds();
        this.commenters = activity.getCommentedIds();
        this.streamType = activity.getActivityStream().getType();
        this.posterId = activity.getPosterId();
        this.parentId = activity.getParentId();
        this.parentCommentId = activity.getParentCommentId();
        this.shareActions = activity.getShareActions() == null ? null : Collections.unmodifiableSet(activity.getShareActions());
        this.files = activity.getFiles() == null ? null : Collections.unmodifiableList(activity.getFiles());
        this.metadatas = activity.getMetadatas() == null ? null : Collections.unmodifiableMap(activity.getMetadatas());
        this.templateParams = activity.getTemplateParams() != null ? Collections.unmodifiableMap(activity.getTemplateParams()) : Collections.emptyMap();
        this.linkedProcessedEntities = activity.getLinkedProcessedEntities() != null ? Collections.unmodifiableMap(activity.getLinkedProcessedEntities()) : null;
    }

    @Override
    public ExoSocialActivity build() {
        if (this == NULL) {
            return null;
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId(this.id);
        activity.setTitle(this.title);
        activity.setBody(this.body);
        if (this.likes != null) {
            activity.setLikeIdentityIds(this.likes);
        }
        activity.setReplyToId(this.replyIds);
        activity.isComment(this.isComment);
        activity.isHidden(this.isHidden);
        activity.isLocked(this.isLocked);
        activity.setPostedTime(this.postedTime);
        activity.setUpdated(this.lastUpdated);
        activity.setCacheTime(this.cacheTime.longValue());
        activity.setUserId(this.userId);
        activity.setSpaceId(this.spaceId);
        activity.setAppId(this.appId);
        activity.setTitleId(this.titleId);
        activity.setBodyId(this.bodyId);
        activity.setType(this.type);
        activity.setTemplateParams(new LinkedHashMap(this.templateParams));
        if (this.linkedProcessedEntities != null) {
            activity.setLinkedProcessedEntities(new LinkedHashMap<String, Object>(this.linkedProcessedEntities));
        }
        activity.setExternalId(this.externalId);
        activity.setShareActions(this.shareActions == null ? null : Collections.unmodifiableSet(this.shareActions));
        activity.setFiles(this.files == null ? null : Collections.unmodifiableList(this.files));
        activity.setMetadatas(this.metadatas == null ? null : Collections.unmodifiableMap(this.metadatas));
        activity.setUrl(this.url);
        if (this.mentioners != null) {
            activity.setMentionedIds(this.mentioners);
        }
        if (this.commenters != null) {
            activity.setCommentedIds(this.commenters);
        }
        activity.setPosterId(this.posterId);
        activity.setParentId(this.parentId);
        activity.setParentCommentId(this.parentCommentId);
        ActivityStream activityStream = activity.getActivityStream();
        activityStream.setId(this.streamId);
        activityStream.setPrettyId(this.streamOwner);
        activityStream.setFaviconUrl(this.streamFaviconUrl);
        activityStream.setPermaLink(this.streamSourceUrl);
        activityStream.setTitle(this.streamTitle);
        activityStream.setType(this.streamType);
        activity.setActivityStream(activityStream);
        return activity;
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getStreamOwner() {
        return this.streamOwner;
    }

    public List<ActivityFile> getFiles() {
        return this.files;
    }

    public Map<String, List<MetadataItem>> getMetadatas() {
        return this.metadatas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityData that = (ActivityData)o;
        return this.isComment == that.isComment && this.isHidden == that.isHidden && this.isLocked == that.isLocked && Objects.equals(this.id, that.id) && Objects.equals(this.title, that.title) && Objects.equals(this.body, that.body) && Arrays.equals(this.likes, that.likes) && Objects.equals(this.postedTime, that.postedTime) && Objects.equals(this.lastUpdated, that.lastUpdated) && Arrays.equals(this.replyIds, that.replyIds) && Objects.equals(this.userId, that.userId) && Objects.equals(this.spaceId, that.spaceId) && Objects.equals(this.appId, that.appId) && Objects.equals(this.titleId, that.titleId) && Objects.equals(this.bodyId, that.bodyId) && Objects.equals(this.type, that.type) && Objects.equals(this.templateParams, that.templateParams) && Objects.equals(this.externalId, that.externalId) && Objects.equals(this.url, that.url) && Objects.equals(this.streamId, that.streamId) && Objects.equals(this.streamOwner, that.streamOwner) && Objects.equals(this.streamFaviconUrl, that.streamFaviconUrl) && Objects.equals(this.streamSourceUrl, that.streamSourceUrl) && Objects.equals(this.streamTitle, that.streamTitle) && Objects.equals(this.streamUrl, that.streamUrl) && Arrays.equals(this.mentioners, that.mentioners) && Arrays.equals(this.commenters, that.commenters) && this.streamType == that.streamType && Objects.equals(this.posterId, that.posterId) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.parentCommentId, that.parentCommentId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.body, this.likes, this.isComment, this.isHidden, this.isLocked, this.postedTime, this.lastUpdated, this.replyIds, this.userId, this.spaceId, this.appId, this.titleId, this.bodyId, this.type, this.templateParams, this.externalId, this.url, this.streamId, this.streamOwner, this.streamFaviconUrl, this.streamSourceUrl, this.streamTitle, this.streamUrl, this.mentioners, this.commenters, this.streamType, this.posterId, this.parentId, this.parentCommentId, this.shareActions, this.files);
    }
}

