/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.oauth;

import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.gatein.api.oauth.BasicOAuthProviderImpl;
import org.gatein.api.oauth.exception.OAuthApiException;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.SocialNetworkService;

public class OAuthProviderImpl
extends BasicOAuthProviderImpl {
    public OAuthProviderImpl(OAuthProviderType internalOAuthProvider, SocialNetworkService socialNetworkService) {
        super(internalOAuthProvider, socialNetworkService);
    }

    public void startOAuthWorkflow(String neededCustomScope) throws OAuthApiException, IOException {
        PortalRequestContext prc = Util.getPortalRequestContext();
        HttpSession session = prc.getRequest().getSession();
        session.setAttribute("_urlToRedirectAfterLinkSocialAccount", (Object)prc.getRequestURI());
        String reqContextPath = prc.getRequestContextPath();
        String requestURI = prc.getRequestURI();
        OAuthProviderType oauthProviderType = this.getInternalOAuthProvider();
        Object initOauthFlowURL = oauthProviderType.getInitOAuthURL(reqContextPath, requestURI);
        if (neededCustomScope != null) {
            initOauthFlowURL = (String)initOauthFlowURL + "&_oauthCustomScope=" + neededCustomScope;
        }
        prc.getResponse().sendRedirect((String)initOauthFlowURL);
    }
}

