/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.measure.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.cs.AxisDirection;

final class GridInfo
extends Grid {
    private static final Map<String, Character> AXIS_TYPES = new HashMap<String, Character>(26);
    private final DimensionInfo[] domain;
    private final VariableInfo[] range;

    private static void addAxisTypes(char c, String ... stringArray) {
        Character c2 = Character.valueOf(c);
        for (String string : stringArray) {
            AXIS_TYPES.put(string, c2);
        }
    }

    GridInfo(DimensionInfo[] dimensionInfoArray, VariableInfo[] variableInfoArray) {
        this.domain = dimensionInfoArray;
        this.range = variableInfoArray;
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensionArray) {
        int n = 0;
        for (DimensionInfo dimensionInfo : this.domain) {
            do {
                if (n < dimensionArray.length) continue;
                return null;
            } while (!dimensionInfo.equals(dimensionArray[n++]));
        }
        return this;
    }

    private String getFilename() {
        for (VariableInfo variableInfo : this.range) {
            String string = variableInfo.getFilename();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String getName() {
        return GridInfo.listNames(this.range, this.range.length, " ");
    }

    private static char getAxisType(String string) {
        Character c;
        if (string != null && (c = AXIS_TYPES.get(string.toLowerCase(Locale.US))) != null) {
            return c.charValue();
        }
        return '\u0000';
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    protected List<Dimension> getDimensions() {
        return UnmodifiableArrayList.wrap((Object[])this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] stringArray) {
        if (stringArray != null) {
            block0: for (String string : stringArray) {
                for (VariableInfo variableInfo : this.range) {
                    if (string.equalsIgnoreCase(variableInfo.getName())) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        TreeMap<VariableInfo, Integer> treeMap = new TreeMap<VariableInfo, Integer>();
        for (int i = 0; i < this.range.length; ++i) {
            VariableInfo variableInfo = this.range[i];
            if (treeMap.put(variableInfo, i) == null) continue;
            throw new DataStoreContentException(Resources.format((short)7, this.getFilename(), variableInfo.getName()));
        }
        Axis[] axisArray = new Axis[this.range.length];
        for (Map.Entry entry : treeMap.entrySet()) {
            int n = (Integer)entry.getValue();
            VariableInfo variableInfo = (VariableInfo)entry.getKey();
            char c = GridInfo.getAxisType(variableInfo.getAxisType());
            if (c == '\u0000' && (c = GridInfo.getAxisType(variableInfo.getAttributeAsString("standard_name"))) == '\u0000' && (c = GridInfo.getAxisType(variableInfo.getDescription())) == '\u0000') {
                Unit<?> unit;
                if (Units.isAngular(variableInfo.getUnit())) {
                    unit = AxisDirections.absolute((AxisDirection)Axis.direction(variableInfo.getUnitsString()));
                    if (AxisDirection.EAST.equals((Object)unit)) {
                        c = '\u03bb';
                    } else if (AxisDirection.NORTH.equals(unit)) {
                        c = '\u03c6';
                    }
                }
                if (c == '\u0000' && (c = GridInfo.getAxisType(variableInfo.getName())) == '\u0000') {
                    unit = variableInfo.getUnit();
                    if (Units.isTemporal(unit)) {
                        c = 't';
                    } else if (Units.isPressure(unit)) {
                        c = 'z';
                    }
                }
            }
            int n2 = 0;
            DimensionInfo[] dimensionInfoArray = variableInfo.dimensions;
            int[] nArray = new int[dimensionInfoArray.length];
            int[] nArray2 = new int[dimensionInfoArray.length];
            block2: for (DimensionInfo dimensionInfo : dimensionInfoArray) {
                for (int i = 0; i < this.domain.length; ++i) {
                    if (this.domain[i] != dimensionInfo) continue;
                    nArray[n2] = i;
                    nArray2[n2++] = dimensionInfo.length;
                    continue block2;
                }
            }
            axisArray[n] = new Axis(c, variableInfo.getAttributeAsString("positive"), ArraysExt.resize((int[])nArray, (int)n2), ArraysExt.resize((int[])nArray2, (int)n2), variableInfo);
        }
        return axisArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.domain) ^ Arrays.hashCode(this.range);
    }

    public boolean equals(Object object) {
        if (object instanceof GridInfo) {
            GridInfo gridInfo = (GridInfo)object;
            return Arrays.equals(this.domain, gridInfo.domain) && Arrays.equals(this.range, gridInfo.range);
        }
        return false;
    }

    static {
        GridInfo.addAxisTypes('\u03bb', "longitude", "lon", "long");
        GridInfo.addAxisTypes('\u03c6', "latitude", "lat");
        GridInfo.addAxisTypes('H', "pressure", "height", "altitude", "barometric_altitude", "elevation", "elev", "geoz");
        GridInfo.addAxisTypes('D', "depth", "depth_below_geoid");
        GridInfo.addAxisTypes('E', "geox", "projection_x_coordinate");
        GridInfo.addAxisTypes('N', "geoy", "projection_y_coordinate");
        GridInfo.addAxisTypes('t', "t", "time", "runtime");
        GridInfo.addAxisTypes('x', "x");
        GridInfo.addAxisTypes('y', "y");
        GridInfo.addAxisTypes('z', "z");
    }
}

