/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptContainer;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptForm;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptManager;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

@ComponentConfig(template="app:/groovy/webui/component/admin/script/UIScriptList.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIScriptList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UIScriptList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "ScriptListIterator");
    public static final String ACTION_SCRIPT_TYPE = "action";
    public static final String INTERCEPTOR_SCRIPT_TYPE = "interceptor";
    public static final String WIDGET_SCRIPT_TYPE = "widget";
    private static final String EDITED_CONFIGURED_SCRIPTS = "EditedConfiguredScripts";
    private String filter = "action";

    public void setTemplateFilter(String filter) {
        this.filter = filter;
    }

    public String getTemplateFilter() {
        return this.filter;
    }

    public UIScriptList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public void updateGrid(List<ScriptData> scriptData, int currentPage) throws Exception {
        Collections.sort(scriptData, new ScriptComparator());
        ListAccessImpl scriptList = new ListAccessImpl(ScriptData.class, scriptData);
        LazyPageList dataPageList = new LazyPageList((ListAccess)scriptList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
        if (currentPage > this.uiPageIterator_.getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(this.uiPageIterator_.getAvailablePage());
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getScriptList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String getScriptCategory() throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        UIScriptManager uiManager = (UIScriptManager)this.getAncestorOfType(UIScriptManager.class);
        UIScriptContainer uiContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
        UIScriptList uiScriptList = (UIScriptList)uiContainer.getChild(UIScriptList.class);
        Node script = scriptService.getECMScriptHome(WCMCoreUtils.getSystemSessionProvider()).getNode(uiScriptList.getTemplateFilter());
        String basePath = scriptService.getBaseScriptPath() + "/";
        return script.getPath().substring(basePath.length());
    }

    public void refresh(String templateFilter, int currentPage) throws Exception {
        this.updateGrid(this.getScript(templateFilter), currentPage);
    }

    public List<ScriptData> getScript(String name) throws Exception {
        ArrayList<ScriptData> scriptData = new ArrayList<ScriptData>();
        List scripts = new ArrayList();
        if (name.equals(ACTION_SCRIPT_TYPE)) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMActionScripts(WCMCoreUtils.getSystemSessionProvider());
        } else if (name.equals(WIDGET_SCRIPT_TYPE)) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMWidgetScripts(WCMCoreUtils.getSystemSessionProvider());
        } else if (name.equals(INTERCEPTOR_SCRIPT_TYPE)) {
            scripts = ((ScriptService)this.getApplicationComponent(ScriptService.class)).getECMInterceptorScripts(WCMCoreUtils.getSystemSessionProvider());
        }
        for (Node scriptNode : scripts) {
            String scriptDescription;
            Node content = scriptNode.getNode("jcr:content");
            try {
                scriptDescription = content.getProperty("dc:description").getValues()[0].getString();
            }
            catch (ArrayIndexOutOfBoundsException are) {
                scriptDescription = scriptNode.getName();
            }
            catch (PathNotFoundException pne) {
                scriptDescription = scriptNode.getName();
            }
            scriptData.add(new ScriptData(scriptNode.getName(), scriptNode.getPath(), StringEscapeUtils.escapeHtml((String)scriptDescription)));
        }
        return scriptData;
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public Node getScriptNode(String templateFilter, String nodeName) throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node category = scriptService.getECMScriptHome(WCMCoreUtils.getSystemSessionProvider()).getNode(templateFilter);
        return category.getNode(nodeName);
    }

    public static class ScriptData {
        private String name;
        private String path;
        private String label;

        public ScriptData(String scriptName, String scriptParth, String label) {
            this.name = scriptName;
            this.path = scriptParth;
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptManager uiManager = (UIScriptManager)((UIScriptList)((Object)event.getSource())).getAncestorOfType(UIScriptManager.class);
            UIScriptContainer uiScriptContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            UIScriptList uiScriptList = (UIScriptList)uiScriptContainer.getChild(UIScriptList.class);
            ScriptService scriptService = (ScriptService)uiScriptList.getApplicationComponent(ScriptService.class);
            String scriptName = event.getRequestContext().getRequestParameter("objectId");
            String namePrefix = uiScriptList.getScriptCategory();
            try {
                scriptService.removeScript(namePrefix + "/" + scriptName, WCMCoreUtils.getSystemSessionProvider());
                Utils.addEditedConfiguredData((String)(namePrefix + "/" + scriptName), (String)"ScriptServiceImpl", (String)UIScriptList.EDITED_CONFIGURED_SCRIPTS, (boolean)true);
            }
            catch (AccessDeniedException ace) {
                throw new MessageException(new ApplicationMessage("UIECMAdminControlPanel.msg.access-denied", null, 1));
            }
            uiScriptList.refresh(uiScriptList.getTemplateFilter(), uiScriptList.uiPageIterator_.getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class EditActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptManager uiManager = (UIScriptManager)((UIScriptList)((Object)event.getSource())).getAncestorOfType(UIScriptManager.class);
            UIScriptContainer uiScriptContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            UIScriptList uiScriptList = (UIScriptList)uiScriptContainer.getChild(UIScriptList.class);
            String scriptName = event.getRequestContext().getRequestParameter("objectId");
            UIScriptForm uiScriptForm = (UIScriptForm)uiScriptContainer.createUIComponent(UIScriptForm.class, null, null);
            uiScriptForm.update(uiScriptList.getScriptNode(uiScriptList.getTemplateFilter(), scriptName), false);
            uiManager.initPopup((UIComponent)uiScriptForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class AddNewActionListener
    extends EventListener<UIScriptList> {
        public void execute(Event<UIScriptList> event) throws Exception {
            UIScriptList uiScriptList = (UIScriptList)((Object)event.getSource());
            UIScriptManager uiManager = (UIScriptManager)uiScriptList.getAncestorOfType(UIScriptManager.class);
            UIScriptContainer uiScriptContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            UIScriptForm uiScriptForm = (UIScriptForm)uiScriptContainer.createUIComponent(UIScriptForm.class, null, null);
            uiManager.initPopup((UIComponent)uiScriptForm);
            uiScriptForm.update(null, true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ScriptComparator
    implements Comparator<ScriptData> {
        @Override
        public int compare(ScriptData o1, ScriptData o2) throws ClassCastException {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

