/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;

final class CachedStatement
implements AutoCloseable {
    final Class<?> type;
    private String identifier;
    private final PreparedStatement statement;
    private ResultSet results;
    long expireTime;
    private final WarningListeners<MetadataSource> listeners;

    CachedStatement(Class<?> clazz, PreparedStatement preparedStatement, WarningListeners<MetadataSource> warningListeners) {
        this.type = clazz;
        this.statement = preparedStatement;
        this.listeners = warningListeners;
    }

    final Object getValue(String string, String string2) throws SQLException, MetadataStoreException {
        ResultSet resultSet;
        if (!string.equals(this.identifier)) {
            this.closeResultSet();
        }
        if ((resultSet = this.results) == null) {
            this.statement.setString(1, string);
            resultSet = this.statement.executeQuery();
            if (!resultSet.next()) {
                String string3 = resultSet.getMetaData().getTableName(1);
                resultSet.close();
                throw new MetadataStoreException(Errors.format((short)122, (Object)string3, (Object)string));
            }
            this.results = resultSet;
            this.identifier = string;
        }
        int n = resultSet.findColumn(string2);
        switch (resultSet.getMetaData().getColumnType(n)) {
            case 1111: {
                return resultSet.getString(n);
            }
        }
        return resultSet.getObject(n);
    }

    private void closeResultSet() throws SQLException {
        ResultSet resultSet = this.results;
        this.results = null;
        if (resultSet != null) {
            boolean bl = resultSet.next();
            resultSet.close();
            if (bl) {
                this.warning(this.type, "<init>", Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)25, (Object)this.identifier));
            }
            this.identifier = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeResultSet();
        this.statement.close();
    }

    private void warning(Class<?> clazz, String string, LogRecord logRecord) {
        logRecord.setSourceClassName(clazz.getCanonicalName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName("org.apache.sis.sql");
        this.listeners.warning(logRecord);
    }
}

