/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.statistic;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.statistic.StatisticUtils;

@Aspect
public class ExoWalletStatisticAspect {
    private static final Log LOG = ExoLogger.getLogger(ExoWalletStatisticAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ExoWalletStatisticAspect ajc$perSingletonInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.wallet.statistic.ExoWalletStatistic)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        boolean replaceCurrentContainer;
        ExoWalletStatisticService statisticService = (ExoWalletStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoWalletStatistic annotation = method.getAnnotation(ExoWalletStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Object result = null;
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainerIfPresent();
        boolean bl = replaceCurrentContainer = !(currentContainer instanceof PortalContainer);
        if (replaceCurrentContainer) {
            ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        }
        try {
            object = result = point.proceed();
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        this.put(parameters, "local_service", service);
                    } else {
                        this.put(parameters, "remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        this.put(parameters, "operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        this.put(parameters, "duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            this.put(parameters, "error_msg", errorMessage);
                        }
                        this.put(parameters, "status", "ko");
                        this.put(parameters, "status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            this.put(parameters, "status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            this.put(parameters, "status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoWalletStatisticAspect.LOG.warn("Error adding statistic log entry in method '{}' for statistic type '{}'", new Object[]{method.getName(), operation, e2});
                    throw throwable;
                }
                finally {
                    if (replaceCurrentContainer) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
                    }
                }
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return object;
            if (local) {
                this.put(parameters, "local_service", service);
            } else {
                this.put(parameters, "remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                this.put(parameters, "operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                this.put(parameters, "duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    this.put(parameters, "error_msg", errorMessage);
                }
                this.put(parameters, "status", "ko");
                this.put(parameters, "status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    this.put(parameters, "status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    this.put(parameters, "status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return object;
        }
        catch (Throwable e) {
            ExoWalletStatisticAspect.LOG.warn("Error adding statistic log entry in method '{}' for statistic type '{}'", new Object[]{method.getName(), operation, e});
            return object;
        }
        finally {
            if (replaceCurrentContainer) {
                ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
            }
        }
    }

    private void put(Map<String, Object> parameters, String key, Object value) {
        if (StringUtils.isNotBlank((CharSequence)key) && value != null) {
            try {
                parameters.put(key, value);
            }
            catch (Exception e) {
                LOG.warn("Error adding statistic log entry with values", new Object[]{key, value, e});
            }
        }
    }

    static {
        try {
            ExoWalletStatisticAspect.ajc$perSingletonInstance = new ExoWalletStatisticAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ExoWalletStatisticAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.exoplatform.wallet.statistic.ExoWalletStatisticAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

