/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.jcr.ItemExistsException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.services.attachments.model.ActivityFileAttachment;
import org.exoplatform.services.attachments.model.ActivityFilesDownloadResource;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.rest.model.AttachmentEntity;
import org.exoplatform.services.attachments.service.AttachmentService;
import org.exoplatform.services.attachments.utils.EntityBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/attachments")
@Api(value="/attachments", description="Managing attachments")
public class AttachmentsRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)AttachmentsRestService.class.getName());
    protected AttachmentService attachmentService;
    protected IdentityManager identityManager;
    protected DownloadService downloadService;

    public AttachmentsRestService(AttachmentService attachmentService, IdentityManager identityManager, DownloadService downloadService) {
        this.attachmentService = attachmentService;
        this.identityManager = identityManager;
        this.downloadService = downloadService;
    }

    @POST
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Link an existing attachment to the given entity (Event, Task, Wiki,...)", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response linkAttachmentToEntity(@ApiParam(value="entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="entity type", required=true) @PathParam(value="entityType") String entityType, @ApiParam(value="file uuid stored in jcr to be attached to the provided entity", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        if (StringUtils.isEmpty((String)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment id must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        Attachment attachment = new Attachment();
        try {
            attachment = this.attachmentService.linkAttachmentToEntity(userIdentityId, entityId, entityType, attachmentId);
        }
        catch (Exception e) {
            LOG.error("Error when trying to link attachments to entity with type {} and id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)attachment).build();
    }

    @PUT
    @Path(value="{entityType}/{entityId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update entity's attachments list", httpMethod="PUT", response=Response.class, consumes="application/x-www-form-urlencoded")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateAttachmentsLinkedToContext(@ApiParam(value="entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="entity type", required=true) @PathParam(value="entityType") String entityType, @ApiParam(value="list of files uuid stored in jcr attached to the provided entity", required=true) @FormParam(value="attachmentId") List<String> attachmentIds) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            this.attachmentService.updateEntityAttachments(userIdentityId, entityId, entityType, attachmentIds);
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to update attachments of entity type {} with id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="{entityType}/{entityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get the list of attachments linked to the given entity", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAttachmentsByEntity(@ApiParam(value="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="Entity type", required=true) @PathParam(value="entityType") String entityType) throws Exception {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity identifier must be a positive integer").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            List<Attachment> attachments = this.attachmentService.getAttachmentsByEntity(userIdentityId, entityId, entityType);
            List<Object> attachmentsEntities = new ArrayList();
            if (!attachments.isEmpty()) {
                attachmentsEntities = attachments.stream().map(attachment -> EntityBuilder.fromAttachment(this.identityManager, attachment)).filter(attachmentEntity -> attachmentEntity.getAcl().isCanView()).collect(Collectors.toList());
            }
            return Response.ok(attachmentsEntities).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachments of entity type {} with id {}: ", new Object[]{entityType, entityId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get the list of attachments linked to the given entity", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAttachmentByIdByEntity(@ApiParam(value="Attachment technical identifier", required=true) @PathParam(value="attachmentId") String attachmentId, @ApiParam(value="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="Entity type", required=true) @PathParam(value="entityType") String entityType) throws Exception {
        if (StringUtils.isBlank((String)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment identifier is mandatory").build();
        }
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity identifier must be a positive integer").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type must not be empty").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            Attachment attachment = this.attachmentService.getAttachmentByIdByEntity(entityType, entityId, attachmentId, userIdentityId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachment with id {}: ", new Object[]{attachmentId, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get an attachment with its jcr uuid", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAttachmentById(@ApiParam(value="Attachment technical identifier", required=true) @PathParam(value="attachmentId") String attachmentId) throws Exception {
        if (StringUtils.isBlank((String)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment identifier is mandatory").build();
        }
        try {
            Attachment attachment = this.attachmentService.getAttachmentById(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to get attachment with id {}: ", new Object[]{attachmentId, e});
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{entityType}/{entityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete the list of attachments linked to the given entity", httpMethod="DELETE", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteAttachmentsByEntity(@ApiParam(value="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="Entity type", required=true) @PathParam(value="entityType") String entityType) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            this.attachmentService.deleteAllEntityAttachments(userIdentityId, entityId, entityType);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error("Error when trying to delete all attachments from entity with type {} and with id '{}' ", new Object[]{entityType, entityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AttachmentContext not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized {} entity with id {}", new Object[]{userIdentityId, entityType, entityId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @DELETE
    @Path(value="{entityType}/{entityId}/{attachmentId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete an attachment linked to the given entity", httpMethod="DELETE", response=Response.class, consumes="application/json", notes="returns deleted attachment")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteEntityAttachment(@ApiParam(value="Entity technical identifier", required=true) @PathParam(value="entityId") long entityId, @ApiParam(value="Entity type", required=true) @PathParam(value="entityType") String entityType, @ApiParam(value="Attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (entityId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity technical identifier must be positive").build();
        }
        if (StringUtils.isEmpty((String)entityType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Entity type is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            AttachmentEntity attachmentEntity = EntityBuilder.fromAttachment(this.identityManager, this.attachmentService.getAttachmentByIdByEntity(entityType, entityId, attachmentId, userIdentityId));
            this.attachmentService.deleteAttachmentItemById(userIdentityId, entityId, entityType, attachmentId);
            return Response.ok((Object)attachmentEntity).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error("Error when trying to delete the attachment with id '{}' from entity with type {} and id '{}'", new Object[]{attachmentId, entityType, entityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AttachmentContext not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized {} entity with id {}", new Object[]{userIdentityId, entityType, entityId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    @POST
    @Path(value="/downloadByPath")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Downloads a list of attachments by it paths", httpMethod="POST", response=Response.class, consumes="application/x-www-form-urlencoded", notes="redirects to download URL of binary that contains the list of attachments in a Zip file if multiple, else the selected file")
    @ApiResponses(value={@ApiResponse(code=303, message="Request Redirect"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response downloadActivityAttachments(@ApiParam(value="Filename to use for download", required=true) @QueryParam(value="fileName") String fileName, @ApiParam(value="List of file attachments to download", required=true) List<ActivityFileAttachment> activityFileAttachments) throws URISyntaxException {
        if (activityFileAttachments == null || activityFileAttachments.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attachments param is mandatory").build();
        }
        if (StringUtils.isBlank((String)fileName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"fileName param is mandatory").build();
        }
        String downloadLink = this.getDownloadLink(activityFileAttachments, fileName);
        URI location = new URI(downloadLink);
        return Response.seeOther((URI)location).build();
    }

    @POST
    @Path(value="/{attachmentId}/move")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Move an attachment to a destination path", httpMethod="POST", response=Response.class, consumes="application/x-www-form-urlencoded", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response moveAttachmentToNewPath(@ApiParam(value="New path", required=true) @FormParam(value="newPath") String newPath, @ApiParam(value="New destination path's drive", required=true) @FormParam(value="newPathDrive") String newPathDrive, @ApiParam(value="New destination path's drive", required=true) @FormParam(value="entityType") String entityType, @ApiParam(value="Entity technical identifier", required=true) @FormParam(value="entityId") long entityId, @ApiParam(value="Entity type", required=true) @PathParam(value="attachmentId") String attachmentId) {
        if (StringUtils.isEmpty((String)newPathDrive)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New destination path's drive is mandatory").build();
        }
        if (StringUtils.isEmpty((String)attachmentId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Attachment id is mandatory").build();
        }
        long userIdentityId = this.getCurrentUserIdentityId();
        try {
            Attachment attachment = this.attachmentService.moveAttachmentToNewPath(userIdentityId, attachmentId, newPathDrive, newPath, entityType, entityId);
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to move attachment with id {} to new destination path {} ", new Object[]{attachmentId, newPath, e});
            return Response.serverError().entity((Object)("Error when trying to move attachment with id " + attachmentId + " to new destination path {} " + newPath)).build();
        }
    }

    @POST
    @Path(value="/newDoc")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="create new document", httpMethod="POST", response=Response.class, notes="This returns a new created document")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response createNewDocument(@ApiParam(value="title", required=false, defaultValue="20") @FormParam(value="title") String title, @ApiParam(value="path of new document", required=true) @FormParam(value="path") String path, @ApiParam(value="New destination path's drive", required=true) @FormParam(value="pathDrive") String pathDrive, @ApiParam(value="template name of new document", required=false, defaultValue="20") @FormParam(value="templateName") String templateName) throws Exception {
        if (StringUtils.isEmpty((String)title)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document title is mandatory").build();
        }
        if (StringUtils.isEmpty((String)templateName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document template name is mandatory").build();
        }
        if (StringUtils.isEmpty((String)path)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document path is mandatory").build();
        }
        if (StringUtils.isEmpty((String)pathDrive)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New destination path's drive is mandatory").build();
        }
        try {
            Identity userIdentity = this.getCurrentUserIdentity();
            Attachment attachment = this.attachmentService.createNewDocument(userIdentity, title, path, pathDrive, templateName);
            return Response.ok((Object)EntityBuilder.fromAttachment(this.identityManager, attachment)).build();
        }
        catch (ItemExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Document with the same name already exist in this current path").build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to a new document with type ", new Object[]{templateName, e});
            return Response.serverError().entity((Object)("Error when trying to a new document with type " + templateName)).build();
        }
    }

    public Identity getCurrentUserIdentity() {
        return ConversationState.getCurrent().getIdentity();
    }

    public long getCurrentUserIdentityId() {
        String currentUser = this.getCurrentUserIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public String getDownloadLink(List<ActivityFileAttachment> activityFileAttachments, String fileName) {
        NodeLocation[] nodeLocations = new NodeLocation[activityFileAttachments.size()];
        for (int i = 0; i < activityFileAttachments.size(); ++i) {
            ActivityFileAttachment activityFileAttachment = activityFileAttachments.get(i);
            nodeLocations[i] = new NodeLocation(activityFileAttachment.getRepository(), activityFileAttachment.getWorkspace(), activityFileAttachment.getDocPath(), activityFileAttachment.getId(), false);
        }
        ActivityFilesDownloadResource dresource = new ActivityFilesDownloadResource(nodeLocations);
        dresource.setDownloadName(fileName);
        String downloadResource = this.downloadService.addDownloadResource((DownloadResource)dresource);
        return this.downloadService.getDownloadLink(downloadResource);
    }
}

