/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.rest;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.RestEntityBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="/v1/poll")
@Api(value="/v1/poll", description="Managing poll")
public class PollRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PollRest.class);
    private PollService pollService;

    public PollRest(PollService pollService) {
        this.pollService = pollService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a new poll", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createPoll(@ApiParam(value="space identifier", required=false) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="Poll object to create", required=true) PollRestEntity pollRestEntity) {
        if (pollRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Poll poll = RestEntityBuilder.toPoll(pollRestEntity);
            List<PollOption> pollOptions = RestEntityBuilder.toPollOptions(pollRestEntity.getOptions());
            poll = this.pollService.createPoll(poll, pollOptions, spaceId, pollRestEntity.getMessage(), currentIdentity, pollRestEntity.getFiles());
            return Response.ok((Object)poll).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create a non authorized poll", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating a poll ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a poll", httpMethod="GET", response=Response.class, notes="This gets the poll with the given id if the authenticated user is a member of the space.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Poll not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getPollById(@ApiParam(value="Poll id", required=true) @PathParam(value="id") String pollId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)pollId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Poll poll = this.pollService.getPollById(Long.parseLong(pollId), currentIdentity);
            if (poll == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List pollOptions = this.pollService.getPollOptionsByPollId(Long.parseLong(pollId), currentIdentity);
            ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
            for (PollOption pollOption : pollOptions) {
                int pollOptionVotes = this.pollService.getPollOptionTotalVotes(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                boolean isPollOptionVoted = this.pollService.isPollOptionVoted(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption(pollOption, pollOptionVotes, isPollOptionVoted);
                pollOptionRestEntities.add(pollOptionRestEntity);
            }
            PollRestEntity pollRestEntity = RestEntityBuilder.fromPoll(poll, pollOptionRestEntities);
            return Response.ok((Object)pollRestEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to get a non authorized poll with id {}", new Object[]{currentIdentity.getUserId(), pollId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Error when getting a poll by id {} ", new Object[]{pollId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/vote/{optionId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Vote in a poll", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Poll option not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response vote(@ApiParam(value="Poll option id", required=true) @PathParam(value="optionId") String optionId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            PollOption pollOption = this.pollService.getPollOptionById(Long.parseLong(optionId), currentIdentity);
            if (pollOption == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Poll poll = this.pollService.getPollById(pollOption.getPollId(), currentIdentity);
            if (poll == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            PollVote pollVote = this.pollService.vote(optionId, String.valueOf(poll.getSpaceId()), currentIdentity);
            return Response.ok((Object)pollVote).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to vote in a non authorized poll option with id {}", new Object[]{currentIdentity.getUserId(), optionId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Error when voting in the poll option id {}", new Object[]{optionId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

