/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.automatic.translation.api.AutomaticTranslationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.simple.JSONObject;

@Path(value="/automatic-translation")
@Api(value="/automatic-translation")
public class AutomaticTranslationRestService
implements ResourceContainer {
    private AutomaticTranslationService automaticTranslationService;
    private static final Log LOG = ExoLogger.getLogger(AutomaticTranslationRestService.class);

    public AutomaticTranslationRestService(AutomaticTranslationService automaticTranslationService) {
        this.automaticTranslationService = automaticTranslationService;
    }

    @GET
    @Path(value="/configuration")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets Automatic Translation configuration", httpMethod="GET", response=Response.class, produces="application/json", notes="This returns the actual configuration for automatic translation")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Not authorized to get the configuration"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response configuration() {
        return Response.ok((Object)this.automaticTranslationService.getConfiguration(), (String)"application/json").build();
    }

    @GET
    @Path(value="/isEnabled")
    @RolesAllowed(value={"users"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Gets status for Automatic Translation feature for users", httpMethod="GET", response=Response.class, produces="text/plain", notes="This returns is the automatic translation feature is active")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation")})
    public Response isEnabled() {
        return Response.ok((Object)("" + this.automaticTranslationService.isFeatureActive())).build();
    }

    @PUT
    @Path(value="/setActiveConnector")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set Automatic translation active connector", httpMethod="PUT", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid Query Input"), @ApiResponse(code=403, message="Not authorized to change the connector"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response setActiveConnector(@ApiParam(value="Connector name", required=true) @QueryParam(value="connector") String connector) {
        connector = connector == null || connector.equals("null") ? "" : connector;
        try {
            this.automaticTranslationService.setActiveConnector(connector);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Unable to set active connector", (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/setApiKey")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set Automatic translation API key", httpMethod="PUT", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid Query Input"), @ApiResponse(code=403, message="Not authorized to change the apiKey"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response setApiKey(@ApiParam(value="Connector name", required=true) @QueryParam(value="connector") String connector, @ApiParam(value="Api Key", required=true) @QueryParam(value="apikey") String apikey) {
        connector = connector == null || connector.equals("null") ? "" : connector;
        try {
            this.automaticTranslationService.setApiKey(connector, apikey);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Unable to set api key connector", (Throwable)e);
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/translate")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="translate message passed in parameter", httpMethod="GET", response=Response.class, produces="application/json", notes="This returns the message transalted in the asked locale, by using the active connector")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid Query Input"), @ApiResponse(code=403, message="Not authorized to use translation"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response translate(@ApiParam(value="message", required=true) @FormParam(value="message") String message, @ApiParam(value="locale", required=true) @FormParam(value="locale") String localeParam, @ApiParam(value="contentType") @FormParam(value="contentType") String contentType, @ApiParam(value="spaceId") @FormParam(value="spaceId") long spaceId) {
        Locale locale = Locale.forLanguageTag(localeParam.replace("_", "-"));
        if (locale == null) {
            return Response.status((int)400).entity((Object)"Locale is not recognized").build();
        }
        String translatedMessage = this.automaticTranslationService.translate(message, locale, contentType, spaceId);
        if (translatedMessage != null) {
            JSONObject resultJSON = new JSONObject();
            resultJSON.put((Object)"locale", (Object)locale.toString());
            resultJSON.put((Object)"translation", (Object)translatedMessage);
            return Response.ok((Object)resultJSON.toString(), (String)"application/json").build();
        }
        return Response.status((int)400).build();
    }
}

