/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/webui/core/UIPopupMessages.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
@Serialized
public class UIPopupMessages
extends UIPopupWindow {
    private List<AbstractApplicationMessage> errors_ = new ArrayList<AbstractApplicationMessage>();
    private List<AbstractApplicationMessage> warnings_ = new ArrayList<AbstractApplicationMessage>();
    private List<AbstractApplicationMessage> infos_ = new ArrayList<AbstractApplicationMessage>();

    public UIPopupMessages() {
        this.setShowMask(true);
        this.setShow(true);
    }

    public List<AbstractApplicationMessage> getErrors() {
        return this.errors_;
    }

    public void setErrors(List<AbstractApplicationMessage> errors_) {
        this.errors_ = errors_;
    }

    public List<AbstractApplicationMessage> getInfos() {
        return this.infos_;
    }

    public void setInfos(List<AbstractApplicationMessage> infos_) {
        this.infos_ = infos_;
    }

    public List<AbstractApplicationMessage> getWarnings() {
        return this.warnings_;
    }

    public void setWarnings(List<AbstractApplicationMessage> warnings_) {
        this.warnings_ = warnings_;
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void addMessage(AbstractApplicationMessage msg) {
        msg.setResourceBundle(this.getResourceBundle());
        switch (msg.getType()) {
            case 0: {
                this.errors_.add(msg);
                break;
            }
            case 1: {
                this.warnings_.add(msg);
                break;
            }
            default: {
                this.infos_.add(msg);
            }
        }
    }

    public void addMessage(ApplicationMessage msg) {
        this.addMessage((AbstractApplicationMessage)msg);
    }

    private ResourceBundle getResourceBundle() {
        RequestContext context = RequestContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        return context.getApplicationResourceBundle();
    }

    public boolean hasMessage() {
        return this.errors_.size() > 0 || this.warnings_.size() > 0 || this.infos_.size() > 0;
    }

    public void clearMessages() {
        this.errors_.clear();
        this.warnings_.clear();
        this.infos_.clear();
    }

    public static class CloseActionListener
    extends EventListener<UIPopupMessages> {
        @Override
        public void execute(Event<UIPopupMessages> event) throws Exception {
            UIPopupMessages uiPopupMessage = event.getSource();
            uiPopupMessage.clearMessages();
            WebuiRequestContext context = event.getRequestContext();
            if (uiPopupMessage.getParent() == null) {
                context.addUIComponentToUpdateByAjax(uiPopupMessage);
                return;
            }
            if (!uiPopupMessage.isShow()) {
                return;
            }
            Object uiParent = uiPopupMessage.getParent();
            context.addUIComponentToUpdateByAjax((UIComponent)uiParent);
            Event<UIComponent> pEvent = ((UIComponent)uiParent).createEvent("ClosePopup", event.getExecutionPhase(), event.getRequestContext());
            if (pEvent != null) {
                pEvent.broadcast();
            }
        }
    }
}

